USE `clinic`;

-- 1. 更新 DEPARTMENTS 表：增加英文名稱
ALTER TABLE `DEPARTMENTS` 
ADD COLUMN `en_name` varchar(50) NOT NULL COMMENT '英文部門名稱' AFTER `name`;

-- 2. 更新 EMPLOYEES 表：直接加入職稱與部門關聯（簡化查詢）
-- 注意：此處僅建立欄位，原本資料需透過 EMPLOYEE_POSITIONS 移轉後再考慮是否刪除舊關聯表
ALTER TABLE `EMPLOYEES` 
ADD COLUMN `jobtitle_id` int(11) DEFAULT NULL AFTER `hire_date`,
ADD COLUMN `department_id` int(11) DEFAULT NULL AFTER `jobtitle_id`;

-- 3. 更新 JOBTITLES 表：增加英文職稱
ALTER TABLE `JOBTITLES` 
ADD COLUMN `en_title` varchar(50) NOT NULL COMMENT '英文職稱名稱' AFTER `title`;

-- 4. 更新 OPD_TREATMENTS 表：縮短 summary 欄位長度
ALTER TABLE `OPD_TREATMENTS` 
MODIFY COLUMN `summary` varchar(255) NOT NULL DEFAULT '' COMMENT '';

-- 5. 更新 clinic_scheduling 表：
--    a. 將 staff_role 由文字列舉改為關聯 ID
--    b. 增加 active_flag 虛擬生成欄位用於唯一索引約束
--    c. 更新唯一索引，確保同一員工在同一時段只有一筆「有效」排班
ALTER TABLE `clinic_scheduling` 
MODIFY COLUMN `staff_role` int(11) NOT NULL COMMENT '職稱 ID (JOBTITLES.position_id)',
ADD COLUMN `active_flag` tinyint(1) GENERATED ALWAYS AS (case when `status` = 'active' then 1 else NULL end) STORED COMMENT '僅 active 排班為 1，其餘為 NULL',
DROP INDEX `uniq_staff_date_shift`,
ADD UNIQUE KEY `uniq_active_staff_date_shift` (`staff_id`,`work_date`,`shift_id`,`active_flag`);

-- 6. 為 CONTACT_HISTORY 等表補上註釋 (Table Comment)
ALTER TABLE `CONTACT_HISTORY` COMMENT = '連絡人變更記錄表';
ALTER TABLE `DEPARTMENTS` COMMENT = '部門基本資料表';
ALTER TABLE `EMPLOYEE_POSITIONS` COMMENT = '員工職稱設定記錄表';
ALTER TABLE `JOBTITLES` COMMENT = '職稱基本資料表';
