<?php

include '../config.php';
if (session_status() == PHP_SESSION_NONE)
	session_start();

$ret = false;
$data = NULL;
$msg = '';
$args = [];

header('Content-Type: application/json');

// 確保請求方法為 POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
	$msg = '無效的網頁請求';
} else {
	$queryStr = file_get_contents('php://input');
	DEBUG(__FILE__, __LINE__, "QUERY: $queryStr");

	$queryArr = json_decode($queryStr, true);
	$args = $queryArr;

	$tbl = 'EMPLOYEES';

	/* for table EMPLOYEES */
	$login_id           = intval($queryArr['login_id'] ?? 0);    // 00. login_id
	$cname              = $queryArr['cname']              ?? ''; // 01. cname
	$ename              = $queryArr['ename']              ?? ''; // 02. ename
	$gender             = $queryArr['gender']             ?? ''; // 03. gender
	$birth_date         = $queryArr['birth_date']         ?? ''; // 04. birth_date
	$blood_type         = $queryArr['blood_type']         ?? ''; // 05. blood_type
	$nationality        = $queryArr['nationality']        ?? ''; // 06. nationality
	$marital_status     = $queryArr['marital_status']     ?? ''; // 07. marital_status
	$hire_date          = $queryArr['hire_date']          ?? ''; // 08. hire_date
	$national_id_type   = $queryArr['national_id_type']   ?? ''; // 09. national_id_type
	$national_id        = $queryArr['national_id']        ?? ''; // 10. national_id
	$mobile_phone       = $queryArr['mobile_phone']       ?? ''; // 11. mobile_phone
	$home_phone         = $queryArr['home_phone']         ?? ''; // 12. home_phone
	$work_phone         = $queryArr['work_phone']         ?? ''; // 13. work_phone
	$email              = $queryArr['email']              ?? ''; // 14. email
	$address_country    = $queryArr['address_country']    ?? ''; // 15. address_country
	$address_city       = $queryArr['address_city']       ?? ''; // 16. address_city
	$address_district   = $queryArr['address_district']   ?? ''; // 17. address_district
	$address_postcode   = $queryArr['address_postcode']   ?? ''; // 18. address_postcode
	$address_detail     = $queryArr['address_detail']     ?? ''; // 19. address_detail
	$emergency_name     = $queryArr['emergency_name']     ?? ''; // 20. emergency_name
	$emergency_relation = $queryArr['emergency_relation'] ?? ''; // 21. emergency_relation
	$emergency_phone    = $queryArr['emergency_phone']    ?? ''; // 22. emergency_phone
	$education_level    = $queryArr['education_level']    ?? ''; // 23. education_level
	$graduation_year    = $queryArr['graduation_year']    ?? ''; // 24. graduation_year
	$graduated_from     = $queryArr['graduated_from']     ?? ''; // 25. graduated_from
	$major              = $queryArr['major']              ?? ''; // 26. major
	$work_experience    = $queryArr['work_experience']    ?? ''; // 27. work_experience
	$jobtitle_id        = intval($queryArr['jobtitle_id'] ?? 0); // 28. jobtitle_id
	$department_id      = intval($queryArr['department_id'] ?? 0); // 29. department_id

	DEBUG(__FILE__, __LINE__, "QUERY: ".json_encode($args));

	if ($gender !== 'M' && $gender !== 'F' && $gender !== 'X')
		$gender = 'X';
	if (!in_array($national_id_type, ['身分證', '護照', '其他']))
		$national_id_type = '其他';

	if (!strlen($cname)) {
		$msg = '沒有員工名稱';
	} else if (!strlen($birth_date)) {
		$msg = '沒有出生日期';
	} else if (!strlen($national_id)) {
		$msg = '沒有身份證件號碼';
	} else if (!strlen($mobile_phone)) {
		$msg = '沒有手機號碼';
	} else {
		/* 檢查是否已存在 */
		$query = $conn->prepare("SELECT COUNT(*) AS ttl FROM $tbl WHERE cname = ? AND national_id_type = ? AND national_id = ? AND mobile_phone = ?");

		if ($query === FALSE) {
			$msg = '資料庫查詢準備失敗: ' . $conn->error;
		} else {
			$query->bind_param('ssss', $cname, $national_id_type, $national_id, $mobile_phone);
			if (!$query->execute()) {
				$msg = '查詢員工失敗: ' . $query->error;
			} else {
				$result = $query->get_result();
				$row = $result->fetch_assoc();
				$query->close();

				if ($row['ttl']) {
					$msg = '該員工已存在';
				} else {
					// 插入新藥材
					$init_phonetic = '';
					$init_pinyin = '';

					if (getPhoneticMap($conn, $phoneticMap) !== false) {
						if (getInitPhonetic($phoneticMap, $cname, $phonetic, $pinyin) !== false) {
							$init_phonetic = $phonetic;
							$init_pinyin = $pinyin;
						}
					} 

					DEBUG(__FILE__, __LINE__,
						"INSERT INTO $tbl (login_id, cname, phonetic, pinyin, ename, gender, birth_date, nationality, marital_status, blood_type, national_id_type, national_id, mobile_phone, home_phone, work_phone, email, address_country, address_city, address_district, address_postcode, address_detail, education_level, graduated_from, major, graduation_year, work_experience, emergency_name, emergency_relation, emergency_phone, hire_date, jobtitle_id, department_id, created_at, updated_at) VALUES ('$login_id', '$cname', '$init_phonetic', '$init_pinyin', '$ename', '$gender', '$birth_date', '$nationality', '$marital_status', '$blood_type', '$national_id_type', '$national_id', '$mobile_phone', '$home_phone', '$work_phone', '$email', '$address_country', '$address_city', '$address_district', '$address_postcode', '$address_detail', '$education_level', '$graduated_from', '$major', '$graduation_year', '$work_experience', '$emergency_name', '$emergency_relation', '$emergency_phone', '$hire_date', '$jobtitle_id', '$department_id', now(), now())");


					$query = $conn->prepare("INSERT INTO $tbl (login_id, cname, phonetic, pinyin, ename, gender, birth_date, nationality, marital_status, blood_type, national_id_type, national_id, mobile_phone, home_phone, work_phone, email, address_country, address_city, address_district, address_postcode, address_detail, education_level, graduated_from, major, graduation_year, work_experience, emergency_name, emergency_relation, emergency_phone, hire_date, jobtitle_id, department_id, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, now(), now())");
					
					$query->bind_param('isssssssssssssssssssssssssssssii', $login_id, $cname, $init_phonetic, $init_pinyin, $ename, $gender, $birth_date, $nationality, $marital_status, $blood_type, $national_id_type, $national_id, $mobile_phone, $home_phone, $work_phone, $email, $address_country, $address_city, $address_district, $address_postcode, $address_detail, $education_level, $graduated_from, $major, $graduation_year, $work_experience, $emergency_name, $emergency_relation, $emergency_phone, $hire_date, $jobtitle_id, $department_id);

					if (!$query->execute()) {
						$msg = '新增員工失敗: ' . $query->error;
					} else {
						$query->close();
						$query = $conn->prepare("SELECT employee_id FROM $tbl WHERE cname = ? AND national_id_type = ? AND national_id = ? AND mobile_phone = ?");
						if ($query === FALSE) {
							$msg = '資料庫查詢準備失敗: ' . $conn->error;
						} else {
							$query->bind_param('ssss', $cname, $national_id_type, $national_id, $mobile_phone);
							if (!$query->execute()) {
								$msg = '查詢員工失敗: ' . $query->error;
							} else {
								$result = $query->get_result();
								$num = $result->num_rows;

								if (!$num) {
									$msg = '新增員工失敗: 沒有員工編號';
								} else {
									$ret = true;
									$row = $result->fetch_assoc();
									$insert_id = $row['employee_id'];
									$msg = '';
								}
								$query->close();
							}
						}
					}
				}
			}
		}
	}
}

logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret, 'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]));
echo json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]);

?>

