<?php

include '../config.php';
if (session_status() == PHP_SESSION_NONE)
	session_start();

$ret = false;
$msg = '';
$args = [];

header('Content-Type: application/json');

// 確保請求方法為 POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
	$msg = '無效的網頁請求';
} else {
	$args = json_decode(file_get_contents('php://input'), true) ?? [];
	$ids = $args['ids'] ?? [];
	$msg = '請選擇要刪除的部門';
	DEBUG(__FILE__, __LINE__, json_encode($ids));

	if (!empty($ids)) {
		// 刪除選中的員工
		$query = $conn->prepare("DELETE FROM DEPARTMENTS WHERE department_id IN (" . implode(',', array_fill(0, count($ids), '?')) . ")");
		$query->bind_param(str_repeat('i', count($ids)), ...$ids);

		if (!$query->execute()) {
			$msg = '刪除部門失敗: '.$conn->error;
		} else {
			$ret = true;
			$msg = '選中的部門已刪除';
		}
	}
}
logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret, 'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, $msg);
echo json_encode(['result'=>$ret, 'data'=>NULL, 'msg'=>$msg]);

