<?php

include '../config.php';
if (session_status() == PHP_SESSION_NONE)
	session_start();

$ret = false;
$data = NULL;
$msg = '無效的部門 ID';
$id = $_GET['id'] ?? 0;
$args = ['id'=>$id];

$tbl = 'DEPARTMENTS';

header('Content-Type: application/json');

try {
	// 檢查是否提供了 department_id
	if (!is_numeric($id) || $id < 1)
		throw new Exception("缺少或無效的部門編號($id)");
	
	$sql = "SELECT a.*,b.cname FROM `$tbl` As a, EMPLOYEES As b WHERE a.manager_id=b.employee_id And department_id = ?";
	DEBUG(__FILE__, __LINE__, "SQL: $sql");

	$query = $conn->prepare($sql);
	if ($query === FALSE)
		throw new Exception('資料庫查詢準備失敗: ' . $conn->error);

	$query->bind_param('i', $id);
	if (!$query->execute())
		throw new Exception('資料庫查詢失敗: ' . $query->error);

	$ret = true;
	$result = $query->get_result();
	$num = $result->num_rows;
	DEBUG(__FILE__, __LINE__, "Num: $num");

	if (!$num) {
		$msg = '查無此部門';
	} else {
		$data = $result->fetch_assoc();
		$msg = '';
	}
	$query->close();
} catch (Exception $e) {
	$msg = $e->getMessage();
}
DEBUG(__FILE__, __LINE__, "MSG: $msg");
logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret, 'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "Ret: ".json_encode($data));
echo json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]);

?>

