<?php

include '../config.php';
if (session_status() == PHP_SESSION_NONE)
	session_start();

$ret = false;
$data = NULL;
$msg = '無效的員工 ID';
$id = $_GET['id'] ?? 0;
$args = ['id'=>$id];

$tbl = 'EMPLOYEES';

header('Content-Type: application/json');

try {
	// 檢查是否提供了 employee_id
	if (preg_match("/^S[0-9]{9}$/", $id, $matches) === FALSE)
		throw new Exception("缺少或無效的員工編號($id)");
	
	$sql = "SELECT * FROM `$tbl` WHERE employee_id = ?";
	DEBUG(__FILE__, __LINE__, "SQL: $sql");

	$query = $conn->prepare($sql);
	if ($query === FALSE)
		throw new Exception('資料庫查詢準備失敗: ' . $conn->error);

	$query->bind_param('s', $id);
	if (!$query->execute())
		throw new Exception('資料庫查詢失敗: ' . $query->error);

	$ret = true;
	$result = $query->get_result();
	$num = $result->num_rows;
	DEBUG(__FILE__, __LINE__, "Num: $num");

	if (!$num) {
		$msg = '查無此員工';
	} else {
		$data = $result->fetch_assoc();
		$msg = '';
	}
	$query->close();
} catch (Exception $e) {
	$msg = $e->getMessage();
}
DEBUG(__FILE__, __LINE__, "MSG: $msg");
logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret, 'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "Ret: ".json_encode($data));
echo json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]);

?>

