<?php

if (session_status() == PHP_SESSION_NONE) {
	session_start();
}

header('Content-Type: application/json');

require_once '../config.php';

$ret = false;
$data = null;
$msg = '';

try {
	// 啟用 mysqli 例外機制
        mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

        // 當 $default_pagesize 小於 15 時，強制使用 15 作為預設分頁大小
        $default_size = ($default_pagesize < 15) ? 15 : $default_pagesize;

	// 取得頁碼參數
	$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
	$size = isset($_GET['size']) ? max(1, (int)$_GET['size']) : $default_pagesize;
	$condition = isset($_GET['condition']) ? trim($_GET['condition']) : '';
	$orderby   = isset($_GET['orderby']) ? trim($_GET['orderby']) : 'position_id';
	$desc = isset($_GET['desc']) ? trim($_GET['desc']) : '';

	$tbl = 'JOBTITLES';

        $desc = strtoupper($desc);
        if ($desc !== 'DESC' && $desc !== 'ASC')
		$desc = 'ASC';

	$args = [
		'page' => $page,
		'size' => $size,
		'condition' => $condition,
		'orderby' => $orderby,
		'desc' => $desc
	];

	DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

	$searchTerm = '%' . $condition . '%';  // 使用通配符查詢

	$term = '';
	$bindType = '';
	$bindValue = [];
	$searchFields = ['position_id', 'title', 'en_title', 'phonetic', 'pinyin'];

        if (strlen($condition)) {
                if (strlen($term)) $term .= " AND ";
                $term .= "(";
                $term .= implode(" LIKE ? OR ", $searchFields) . " LIKE ? ";
                $term .= ")";
                $bindType .= str_repeat("s", count($searchFields));
                for ($i = 0; $i < count($searchFields); $i++) {
                        $bindValue[] = $searchTerm;
                }
        }

        if ($orderby === 'position_id')
                $orderbyStr = "$orderby $desc";

        DEBUG(__FILE__, __LINE__, "page: $page, size: $size, condition: $condition");
        DEBUG(__FILE__, __LINE__, "ORDERBYSTR: $orderbyStr");

	// 計算總記錄數
        $totalQuery = sprintf(
                "SELECT COUNT(*) as total FROM %s %s",
                $tbl, (strlen($term)) ? "WHERE $term" : ""
        );

        DEBUG(__FILE__, __LINE__, "QUERY: $totalQuery");

        $totalStmt = $conn->prepare($totalQuery);
        if (strlen($term)) {
                $totalStmt->bind_param($bindType, ...$bindValue);
                DEBUG(__FILE__, __LINE__, "term: $term");
        }
        $totalStmt->execute();
        $totalResult = $totalStmt->get_result();
        $totalRow = $totalResult->fetch_assoc();
        $total = $totalRow['total'];

        DEBUG(__FILE__, __LINE__, "total: $total");

        // 計算頁數及開始位置
        $maxPage = ceil($total / $size);
        if ($page > $maxPage) {
                $page = $maxPage;
        }
        $start = ($page - 1) * $size;

        // 查詢資料，若有搜尋條件則加上 WHERE 子句
        $query = sprintf(
                "SELECT * FROM %s %s ORDER BY %s LIMIT ?, ?",
                $tbl,
                (strlen($term)) ? "WHERE $term" : "",
                $orderbyStr
        );

        DEBUG(__FILE__, __LINE__, "QUERY: $query");
        DEBUG(__FILE__, __LINE__, "START: $start, SIZE: $size");

	$bindType .= "ii";
        $bindParams = $bindValue;
        array_push($bindParams, $start, $size);

        $stmt = $conn->prepare($query);
        $stmt->bind_param($bindType, ...$bindParams);
        $stmt->execute();
        $result = $stmt->get_result();

        $records = [];
        while ($row = $result->fetch_assoc()) {
                $records[] = $row;
        }
        $ret = true;
        $data = ['ttl' => $total, 'page' => $page, 'records' => $records];

        $stmt->close();
} catch (Exception $e) {
        $msg = 'Exception caught: ' . $e->getMessage();
        DEBUG(__FILE__, __LINE__, $msg);
}

DEBUG(__FILE__, __LINE__, "MSG: $msg");
logAction($conn, __FILE__, '', $args, json_encode(['result' => $ret, 'msg' => $msg]));
DEBUG(__FILE__, __LINE__, "Ret: " . json_encode($data));
echo json_encode(['result' => $ret, 'data' => $data, 'msg' => $msg]);

?>

