<?php
require_once __DIR__ . '/../config.php';

if (!function_exists('DEBUG')) { function DEBUG() {} }
if (!function_exists('logAction')) { function logAction() {} }

$args = json_decode(file_get_contents('php://input'), true);
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

$ret = false;
$msg = '';
$ids = [];

try {
	if (is_numeric($args['id'])) {
		$ids[] = $args['id'];
	} else if (is_array($args['id'])) {
		$ids = $args['id'];
	} else {
		throw new Exception('未指定排班資料');
	}

	$placeholders = implode(',', array_fill(0, count($ids), '?'));
	$types = str_repeat('i', count($ids));

	$sql = "UPDATE clinic_scheduling SET status = 'cancel' WHERE id IN ($placeholders)";
	DEBUG(__FILE__, __LINE__, "SQL: $sql");

	$stmt = $conn->prepare($sql);
	if (!$stmt) throw new Exception($conn->error);

	$stmt->bind_param($types, ...$ids);
	$ret = $stmt->execute();
	$stmt->close();

	$msg = $ret ? '已取消排班' : '取消失敗';

} catch (Exception $e) {
	$msg = $e->getMessage();
}

logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret,'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "MSG: $msg");
echo json_encode(['result'=>$ret,'msg'=>$msg]);

