<?php
require_once __DIR__ . '/../config.php';

if (!function_exists('DEBUG')) { function DEBUG() {} }
if (!function_exists('logAction')) { function logAction() {} }

$args = json_decode(file_get_contents('php://input'), true);
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

$ret = false;
$msg = '';
$data = [
    'ttl' => 0,
    'records' => []
];

try {
    $sql = "UPDATE clinic_shift_settings SET is_active = 0 WHERE id = ?";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception($conn->error);
    }

    $stmt->bind_param('i', $args['id']);
    $ret = $stmt->execute();
    if (!$ret) {
        throw new Exception($stmt->error);
    }

    $stmt->close();
    $msg = '班別已停用';

    // 回傳最新列表
    $res = $conn->query("
        SELECT id, shift_code, shift_name, start_time, end_time, is_active
        FROM clinic_shift_settings
        WHERE is_active = 1
        ORDER BY start_time
    ");

    while ($row = $res->fetch_assoc()) {
        $data['records'][] = $row;
    }
    $data['ttl'] = count($data['records']);

} catch (Exception $e) {
    $ret = false;
    $msg = $e->getMessage();
}

logAction(
    $conn,
    __FILE__,
    '',
    $args,
    json_encode(['result' => $ret, 'msg' => $msg])
);
DEBUG(__FILE__, __LINE__, "MSG: $msg");

echo json_encode([
    'result' => $ret,
    'data'   => $data,
    'msg'    => $msg
]);

