<?php
require_once __DIR__ . '/_lib.php';

$ret = false;
$msg = '';
$data = [];

$args = $_GET;
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

$month = $args['month'] ?? '';

if (!$month) {
    $msg = '缺少 month 參數';
} else {

    header('Content-Type: text/csv; charset=utf-8');
    header("Content-Disposition: attachment; filename=\"scheduling_$month.csv\"");

    $out = fopen('php://output', 'w');

    fputcsv($out, [
        'work_date','staff_id','staff_name','staff_role',
        'shift_id','shift_name','start_time','end_time','remark','status'
    ]);

    $sql = "
        SELECT s.*, e.cname AS staff_name
        FROM clinic_scheduling s
        JOIN EMPLOYEES e ON e.employee_id = s.staff_id
        WHERE s.work_date LIKE CONCAT(?, '%')
          AND s.status='active'
        ORDER BY s.work_date, s.start_time
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $month);
    $stmt->execute();
    $res = $stmt->get_result();

    while ($r = $res->fetch_assoc()) {
        fputcsv($out, [
            $r['work_date'],
            $r['staff_id'],
            $r['staff_name'],
            $r['staff_role'],
            $r['shift_id'],
            $r['shift_name'],
            $r['start_time'],
            $r['end_time'],
            $r['remark'],
            $r['status']
        ]);
    }

    fclose($out);
    $ret = true;
    $msg = '匯出完成';
}

DEBUG(__FILE__, __LINE__, "MSG: $msg");
logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret,'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "Ret: ".json_encode($data));

