<?php
require_once __DIR__ . '/../config.php';

header('Content-Type: application/json; charset=utf-8');

if (!function_exists('DEBUG')) { function DEBUG() {} }
if (!function_exists('logAction')) { function logAction() {} }

$args = $_GET;
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

$ret = true;
$msg = '';
$data = ['ttl' => 0, 'page' => 1, 'records' => []];

// 取得 employee_id（支援 GET / POST）
$empId = '';
if (isset($_GET['employee_id'])) {
	$empId = trim($_GET['employee_id']);
} elseif (isset($_POST['employee_id'])) {
	$empId = trim($_POST['employee_id']);
}
DEBUG(__FILE__, __LINE__, "empId: $empId");

try {
	// === empId 空值防呆 ===
	if ($empId === '') {
		$msg = 'employee_id is required';
		throw new Exception($msg);
	}

	$sql = "SELECT a.employee_id,a.cname,a.jobtitle_id,b.title FROM EMPLOYEES a JOIN JOBTITLES b WHERE a.employee_id = ? and a.jobtitle_id=b.position_id";
	$stmt = $conn->prepare($sql);
	if (!$stmt) throw new Exception($conn->error);

	// bind_param（⭐ 關鍵）
	$stmt->bind_param('s', $empId);

	if (!$stmt->execute()) {
		throw new Exception($stmt->error);
	}

	$result = $stmt->get_result();
	while ($row = $result->fetch_assoc()) {
		$data['records'][] = $row;
	}

	$data['ttl'] = count($data['records']);
	$stmt->close();

} catch (Exception $e) {
	$ret = false;
	$msg = $e->getMessage();
}

logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret,'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "RET: " . json_encode(['result'=>$ret,'data'=>$data,'msg'=>$msg]));
echo json_encode(['result'=>$ret,'data'=>$data,'msg'=>$msg]);

