<?php
require_once(__DIR__ . '/../config.php');

header('Content-Type: application/json; charset=utf-8');

$ret  = false;
$msg  = '';
$data = [
	'ttl' => 1,
	'records' => []
];

try {

	/* === 參數 === */
	$month = $_GET['month'] ?? '';
	if (!preg_match('/^\d{4}-\d{2}$/', $month)) {
		throw new Exception('Invalid month format');
	}

	$startDate = $month . '-01';
	$endDate   = date('Y-m-t', strtotime($startDate));

	/* === DEBUG：參數 === */
	DEBUG(__FILE__, __LINE__, 'ARGS: ' . json_encode($_GET));

	/* === SQL === */
	$sql = "
	SELECT
	    cs.id,
	    cs.work_date,
	    cs.staff_id,
	    e.cname                AS staff_name,
	    cs.staff_role          AS jobtitle_id,
	    jt.title               AS jobtitle_title,
	    cs.shift_id,
	    cs.shift_name,
	    cs.start_time,
	    cs.end_time,
	    cs.remark
	FROM clinic_scheduling cs
	LEFT JOIN EMPLOYEES e
	    ON cs.staff_id = e.employee_id
	LEFT JOIN JOBTITLES jt
	    ON cs.staff_role = jt.position_id
	WHERE cs.status = 'active' AND cs.work_date BETWEEN ? AND ?
	ORDER BY cs.work_date, cs.start_time
    ";

	$stmt = $conn->prepare($sql);
	if (!$stmt) {
		throw new Exception('Prepare failed: ' . $conn->error);
	}

	if (!$stmt->bind_param('ss', $startDate, $endDate)) {
		throw new Exception('bind_param failed: ' . $stmt->error);
	}

	if (!$stmt->execute()) {
		throw new Exception('Execute failed: ' . $stmt->error);
	}

	$result = $stmt->get_result();
	while ($row = $result->fetch_assoc()) {
		$data['records'][] = $row;
	}
	$stmt->close();

	$ret = true;
	$msg = 'OK';

} catch (Exception $e) {

	$ret = false;
	$msg = $e->getMessage();
}

/* === DEBUG / LOG === */
DEBUG(__FILE__, __LINE__, 'MSG: ' . $msg);
DEBUG(__FILE__, __LINE__, 'RET: ' . json_encode($data));

logAction(
	$conn,
	__FILE__,
	'',
	$_GET,
	json_encode(['result' => $ret, 'msg' => $msg])
);

/* === 回傳 === */
echo json_encode([
	'result' => $ret,
	'data'   => $data,
	'msg'    => $msg
]);

