<?php
require_once __DIR__ . '/../config.php';

if (!function_exists('DEBUG')) { function DEBUG() {} }
if (!function_exists('logAction')) { function logAction() {} }

$args = $_GET;
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

$ret = true;
$msg = '';
$data = [
    'ttl' => 0,
    'records' => []
];

try {
    $sql = "
        SELECT
            id,
            shift_code,
            shift_name,
            start_time,
            end_time,
            is_active
        FROM clinic_shift_settings
        WHERE is_active = 1
        ORDER BY start_time
    ";

    $result = $conn->query($sql);
    if (!$result) {
        throw new Exception($conn->error);
    }

    while ($row = $result->fetch_assoc()) {
        $data['records'][] = $row;
    }

    $data['ttl'] = count($data['records']);

} catch (Exception $e) {
    $ret = false;
    $msg = $e->getMessage();
}

logAction(
    $conn,
    __FILE__,
    '',
    $args,
    json_encode(['result' => $ret, 'msg' => $msg])
);

echo json_encode([
    'result' => $ret,
    'data'   => $data,
    'msg'    => $msg
]);

