<?php
require_once __DIR__ . '/_lib.php';

$ret = false;
$msg = '';
$data = ['inserted'=>0,'skipped'=>0,'errors'=>[]];

$args = $_FILES;
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode(array_keys($args)));

if (!isset($_FILES['file'])) {
    $msg = '未上傳檔案';
} else {

    $fp = fopen($_FILES['file']['tmp_name'], 'r');
    $header = fgetcsv($fp);

    while (($row = fgetcsv($fp)) !== false) {

        [
            $work_date,
            $staff_id,
            $staff_name,
            $staff_role,
            $shift_id,
            $shift_name,
            $start_time,
            $end_time,
            $remark,
            $status
        ] = $row;

        if (checkTimeOverlap($conn, $staff_id, $work_date, $start_time, $end_time)) {
            $data['skipped']++;
            $data['errors'][] = "$work_date $staff_id 時段重疊";
            continue;
        }

        $sql = "
            INSERT INTO clinic_scheduling
            (staff_id, staff_role, work_date, shift_id, shift_name,
             start_time, end_time, remark, status)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'active')
        ";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param(
            'ssssssss',
            $staff_id,
            $staff_role,
            $work_date,
            $shift_id,
            $shift_name,
            $start_time,
            $end_time,
            $remark
        );

        if ($stmt->execute()) {
            $id = $stmt->insert_id;
            logSchedulingAudit($conn, $id, 'import', null, [
                'staff_id'=>$staff_id,
                'work_date'=>$work_date,
                'shift_id'=>$shift_id
            ]);
            $data['inserted']++;
        } else {
            $data['skipped']++;
            $data['errors'][] = "$work_date $staff_id 寫入失敗";
        }
    }

    fclose($fp);
    $ret = true;
    $msg = '匯入完成';
}

DEBUG(__FILE__, __LINE__, "MSG: $msg");
logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret,'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "Ret: ".json_encode($data));
echo json_encode(['result'=>$ret,'data'=>$data,'msg'=>$msg]);

