<?php
require_once __DIR__ . '/../config.php';

if (!function_exists('DEBUG')) { function DEBUG() {} }
if (!function_exists('logAction')) { function logAction() {} }

$args = json_decode(file_get_contents('php://input'), true);
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

$ret = false;
$msg = '';
$data = [
    'ttl' => 0,
    'records' => []
];

try {

    if (empty($args['id'])) {
        throw new Exception('缺少排班編號');
    }
    if (empty($args['shift_id'])) {
        throw new Exception('未指定班別');
    }

    /* ========= 檢查班別 ========= */
    $stmt = $conn->prepare("
        SELECT shift_name
        FROM clinic_shift_settings
        WHERE id = ? AND is_active = 1
    ");
    $stmt->bind_param('i', $args['shift_id']);
    $stmt->execute();
    $res = $stmt->get_result();
    $shift = $res->fetch_assoc();
    $stmt->close();

    if (!$shift) {
        throw new Exception('班別不存在或已停用');
    }

    $shift_name = $shift['shift_name'];

    /* ========= 重疊檢查（排除自己） ========= */
    $stmt = $conn->prepare("
        SELECT id
        FROM clinic_scheduling
        WHERE staff_id = ?
          AND work_date = ?
          AND status = 'active'
          AND id <> ?
          AND NOT (
              end_time <= ? OR start_time >= ?
          )
    ");
    $stmt->bind_param(
        'ssiss',
        $args['staff_id'],
        $args['work_date'],
        $args['id'],
        $args['start_time'],
        $args['end_time']
    );
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        throw new Exception('該人員在此時段已有其他排班');
    }
    $stmt->close();

    /* ========= 更新排班 ========= */
    $sql = "
        UPDATE clinic_scheduling SET
            staff_id   = ?,
            staff_role = ?,
            work_date  = ?,
            shift_id   = ?,
            shift_name = ?,
            start_time = ?,
            end_time   = ?,
            remark     = ?
        WHERE id = ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        'sssissssi',
        $args['staff_id'],
        $args['staff_role'],
        $args['work_date'],
        $args['shift_id'],
        $shift_name,
        $args['start_time'],
        $args['end_time'],
        $args['remark'],
        $args['id']
    );

    $ret = $stmt->execute();
    if (!$ret) {
        throw new Exception($stmt->error);
    }

    $stmt->close();
    $msg = '更新排班成功';

} catch (Exception $e) {
    $ret = false;
    $msg = $e->getMessage();
}

logAction(
    $conn,
    __FILE__,
    '',
    $args,
    json_encode(['result' => $ret, 'msg' => $msg])
);
DEBUG(__FILE__, __LINE__, "MSG: $msg");

echo json_encode([
    'result' => $ret,
    'data'   => $data,
    'msg'    => $msg
]);

