<?php

include '../config.php'; // 載入配置文件
if (session_status() == PHP_SESSION_NONE)
	session_start();

DEBUG(__FILE__, __LINE__, "111111111111111111111111111111111111111");

$data = json_decode(file_get_contents("php://input"), true);
$currentPassword = $data['currentPassword'] ?? '';
$newPassword = $data['newPassword'] ?? '';
DEBUG(__FILE__, __LINE__, "oldPWD: $currentPassword, newPWD: $newPassword");

if ($currentPassword === '' && isset($data['old_password']))
	$currentPassword = $data['old_password'];

if ($newPassword === '' && isset($data['new_password']))
	$newPassword = $data['new_password'];
DEBUG(__FILE__, __LINE__, "oldPWD: $currentPassword, newPWD: $newPassword");

$args = $data;

// 假設用戶已登入，可以通過 session 來獲取當前登入的用戶名稱
$username = $_SESSION['username'] ?? '';

DEBUG(basename(__FILE__), __LINE__, "username: $username");

if (!strlen($username)) {
	$msg = '沒有使用者名稱';
	logAction($conn, __FILE__, '', $data, json_encode(['result'=>false, 'msg'=>$msg]));
	DEBUG(__FILE__, __LINE__, "沒有使用者名稱");
	echo json_encode(['result'=>false, 'data'=>NULL, 'msg'=>$msg]);
	return;
}
// 從資料庫中獲取當前用戶的密碼哈希值
$stmt = $conn->prepare("SELECT password FROM authority WHERE username = ?");
if ($stmt === FALSE) {
	$msg = '資料庫查詢準備失敗: '.$conn->error;
	logAction($conn, __FILE__, '', $data, json_encode(['result'=>false, 'msg'=>$msg]));
	DEBUG(__FILE__, __LINE__, $msg);
	echo json_encode(['result'=>false, 'data'=>NULL, 'msg'=>$msg]);
	return;
}
$stmt->bind_param('s', $username);
if (!$stmt->execute()) {
	$msg = '資料庫查詢失敗: '.$stmt->error;
	logAction($conn, __FILE__, '', $data, json_encode(['result'=>false, 'msg'=>$msg]));
	DEBUG(__FILE__, __LINE__, $msg);
	echo json_encode(['result'=>false, 'data'=>NULL, 'msg'=>$msg]);
	return;
}
$stmt->bind_result($storedPassword);
$stmt->fetch();
$stmt->close();

// 驗證當前密碼是否正確
if (!password_verify($currentPassword, $storedPassword)) {
	$msg = '當前密碼錯誤';
	logAction($conn, __FILE__, '', $data, json_encode(['result'=>false, 'msg'=>$msg]));
	DEBUG(__FILE__, __LINE__, $msg);
	echo json_encode(["result" => false, 'data'=>NULL, "msg" => $msg]);
	return;
}
// 將新密碼哈希化並更新到資料庫中
$newPasswordHash = password_hash($newPassword, PASSWORD_DEFAULT);
$stmt = $conn->prepare("UPDATE authority SET password = ? WHERE username = ?");
$stmt->bind_param('ss', $newPasswordHash, $username);

if ($stmt->execute()) {
	$msg = '密碼修改成功';
	logAction($conn, __FILE__, '', $data, json_encode(['result'=>true, 'msg'=>$msg]));
	DEBUG(__FILE__, __LINE__, $msg);
	echo json_encode(["result" => true, 'data'=>NULL, "msg" => $msg]);
} else {
	$msg = '密碼修改失敗';
	logAction($conn, __FILE__, '', $data, json_encode(['result'=>false, 'msg'=>$msg]));
	DEBUG(__FILE__, __LINE__, $msg);
	echo json_encode(["result" => false, 'data'=>NULL, "msg" => $msg]);
}

?>

