<?php
include '../config.php';
if (session_status() == PHP_SESSION_NONE) session_start();

$ret = false;
$data = NULL;
$msg = '更新掛號失敗';
$args = [];

header('Content-Type: application/json');

try {
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

    $raw = file_get_contents('php://input');
    $args = json_decode($raw, true);
    if (!is_array($args)) $args = [];

    DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

    $id         = isset($args['id']) ? intval($args['id']) : 0;
    $patient_id = isset($args['patient_id']) ? trim($args['patient_id']) : '';
    $doctor_id  = isset($args['doctor_id']) ? trim($args['doctor_id']) : '';
    $room_id    = isset($args['room_id']) ? trim($args['room_id']) : null;
    $type       = isset($args['type']) ? trim($args['type']) : '現場掛號';
    $appt_date  = isset($args['appt_date']) ? trim($args['appt_date']) : '';
    $appt_no    = isset($args['appt_no']) ? intval($args['appt_no']) : 0;
    $status     = isset($args['status']) ? trim($args['status']) : '預約';

    if ($id <= 0) throw new Exception("缺少或無效的掛號編號($id)");
    if (!preg_match('/^P[0-9]{9}$/', $patient_id)) throw new Exception("缺少或無效的病患編號($patient_id)");
    if ($doctor_id === '') throw new Exception("缺少醫師編號");
    if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $appt_date)) throw new Exception("缺少或無效的掛號日期($appt_date)");
    if ($appt_no <= 0) throw new Exception("缺少或無效的看診號碼($appt_no)");

    $type_allow = ['網路掛號','現場掛號','診間預掛'];
    if (!in_array($type, $type_allow, true)) throw new Exception("無效的掛號類型($type)");

    $status_allow = ['預約','完成','看診中','取消'];
    if (!in_array($status, $status_allow, true)) throw new Exception("無效的掛號狀態($status)");

    if ($room_id === '') $room_id = null;

    // 防重：同醫師、同日期、同號碼、未取消，且不是自己 -> 不可重覆
    $dup = $conn->prepare("SELECT id FROM APPOINTMENTS WHERE doctor_id=? AND appt_date=? AND appt_no=? AND status<>'取消' AND id<>? LIMIT 1");
    $dup->bind_param('ssii', $doctor_id, $appt_date, $appt_no, $id);
    $dup->execute();
    $dupRes = $dup->get_result();
    if ($dupRes && $dupRes->num_rows > 0) {
        $row = $dupRes->fetch_assoc();
        throw new Exception("此號碼已被使用(掛號編號: {$row['id']})");
    }
    $dup->close();

    $sql = "UPDATE APPOINTMENTS SET patient_id=?, doctor_id=?, room_id=?, type=?, appt_date=?, appt_no=?, status=? WHERE id=?";
    $stmt = $conn->prepare($sql);
    if ($stmt === FALSE) throw new Exception('資料庫查詢準備失敗: ' . $conn->error);

    $stmt->bind_param('sssssisi', $patient_id, $doctor_id, $room_id, $type, $appt_date, $appt_no, $status, $id);
    $stmt->execute();
    $stmt->close();

    $data = ['id' => $id];
    $ret = true;
    $msg = '';
} catch (Exception $e) {
    $msg = $e->getMessage();
}

DEBUG(__FILE__, __LINE__, "MSG: $msg");
logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret, 'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "Ret: ".json_encode($data));
echo json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]);
?>

