<?php

include '../config.php';
if (session_status() == PHP_SESSION_NONE)
	session_start();

$ret = false;
$data = NULL;
$msg = '';
$args = [];

header('Content-Type: application/json');

// 確保請求方法為 POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
	$msg = '無效的網頁請求';
} else {
	$queryStr = file_get_contents('php://input');
	DEBUG(__FILE__, __LINE__, "QUERY: $queryStr");

	$queryArr = json_decode($queryStr, true);
	$args = $queryArr;

	$tbl = 'DEPARTMENTS';

	/* for table EMPLOYEES */
	$name        = $queryArr['name']             ?? '';   // 01. name
	$enname      = $queryArr['en_name']          ?? '';   // 01. en_name
	$parent_dept = (int)$queryArr['parent_dept'] ?? 0;    // 02. parent_dept
	$midStr      = $queryArr['manager_id']       ?? null; // 03. manager_id
	$extension   = $queryArr['extension']        ?? null; // 04. extension
	DEBUG(__FILE__, __LINE__, "midStr: $midStr");
	if (preg_match("/(S[0-9]{9}) /", $midStr, $arr)) {
		$manager_id = substr($midStr, 0, 10);
	}
	DEBUG(__FILE__, __LINE__, "manager_id: $manager_id");
	DEBUG(__FILE__, __LINE__, "QUERY: ".json_encode($args));

	if (!strlen($name)) {
		$msg = '沒有部門名稱';
	} else {
		/* 檢查是否已存在 */
		$query = $conn->prepare("SELECT COUNT(*) AS ttl FROM $tbl WHERE name = ?");

		if ($query === FALSE) {
			$msg = '資料庫查詢準備失敗: ' . $conn->error;
		} else {
			$query->bind_param('s', $name);
			if (!$query->execute()) {
				$msg = '查詢部門失敗: ' . $query->error;
			} else {
				$result = $query->get_result();
				$row = $result->fetch_assoc();
				$query->close();

				if ($row['ttl']) {
					$msg = '該部門已存在';
				} else {
					// 插入新部門
					$init_phonetic = '';
					$init_pinyin = '';

					if (getPhoneticMap($conn, $phoneticMap) !== false) {
						if (getInitPhonetic($phoneticMap, $name, $phonetic, $pinyin) !== false) {
							$init_phonetic = $phonetic;
							$init_pinyin = $pinyin;
						}
					} 

					DEBUG(__FILE__, __LINE__,
						"INSERT INTO $tbl (name, en_name, phonetic, pinyin, parent_dept, manager_id, extension, created_at, updated_at) VALUES ('$name', '$enname', '$init_phonetic', '$init_pinyin', '$parent_dept', '$manager_id', '$extension', now(), now())");


					$query = $conn->prepare("INSERT INTO $tbl (name, en_name, phonetic, pinyin, parent_dept, manager_id, extension, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, now(), now())");
					
					$query->bind_param('ssssiss', $name, $enname, $init_phonetic, $init_pinyin, $parent_dept, $manager_id, $extension);

					if (!$query->execute()) {
						$msg = '新增部門失敗: ' . $query->error;
					} else {
						$msg = '新增部門成功';
						$ret = true;
					}
				}
			}
		}
	}
}

logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret, 'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]));
echo json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]);

?>

