<?php

require_once __DIR__ . '/../config.php';

if (session_status() == PHP_SESSION_NONE)
	session_start();

$ret = false;
$data = NULL;
$msg = '';
$args = [];

header('Content-Type: application/json');

// 確保請求方法為 POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
	$msg = '無效的網頁請求';
} else {
	$queryStr = file_get_contents('php://input');
	DEBUG(__FILE__, __LINE__, "QUERY: $queryStr");

	$queryArr = json_decode($queryStr, true);
	$args = $queryArr;

	$tbl = 'JOBTITLES';

	/* for table JOBTITLES */
	$title        = $queryArr['title']        ?? ''; // 01. title
	$entitle      = $queryArr['en_title']     ?? ''; // 01. en_title
	$category     = $queryArr['category']     ?? ''; // 02. category
	$salary_range = $queryArr['salary_range'] ?? ''; // 03. salary_range
	DEBUG(__FILE__, __LINE__, "QUERY: ".json_encode($args));

	if (!strlen($title)) {
		$msg = '沒有職稱名稱';
	} else {
		/* 檢查是否已存在 */
		$query = $conn->prepare("SELECT COUNT(*) AS ttl FROM $tbl WHERE title = ?");

		if ($query === FALSE) {
			$msg = '資料庫查詢準備失敗: ' . $conn->error;
		} else {
			$query->bind_param('s', $title);
			if (!$query->execute()) {
				$msg = '查詢職稱失敗: ' . $query->error;
			} else {
				$result = $query->get_result();
				$row = $result->fetch_assoc();
				$query->close();

				if ($row['ttl']) {
					$msg = '該職稱已存在';
				} else {
					// 插入新職稱
					$init_phonetic = '';
					$init_pinyin = '';

					if (getPhoneticMap($conn, $phoneticMap) !== false) {
						if (getInitPhonetic($phoneticMap, $title, $phonetic, $pinyin) !== false) {
							$init_phonetic = $phonetic;
							$init_pinyin = $pinyin;
						}
					} 

					DEBUG(__FILE__, __LINE__,
						"INSERT INTO $tbl (title, en_title, phonetic, pinyin, category, salary_range, created_at, updated_at) VALUES ('$title', '$entitle', '$init_phonetic', '$init_pinyin', '$category', '$salary_range', now(), now())");


					$query = $conn->prepare("INSERT INTO $tbl (title, en_title, phonetic, pinyin, category, salary_range, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, now(), now())");
					
					$query->bind_param('ssssss', $title, $entitle, $init_phonetic, $init_pinyin, $category, $salary_range);

					if (!$query->execute()) {
						$msg = '新增職稱失敗: ' . $query->error;
					} else {
						$msg = '新增職稱成功';
						$ret = true;
					}
				}
			}
		}
	}
}

logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret, 'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]));
echo json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]);

?>

