<?php
require_once __DIR__ . '/../config.php';

if (session_status() == PHP_SESSION_NONE)
        session_start();

$args = json_decode(file_get_contents("php://input"), true) ?? [];
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

$ret = false;
$msg = '';

$department_id = intval($args['department_id'] ?? 0);
$name          = $args['name'] ?? '';
$en_name       = $args['en_name'] ?? '';
$parent_dept   = intval($args['parent_dept'] ?? 0);
$midStr        = $args['manager_id'] ?? '';
$extension     = $args['extension'] ?? '';

DEBUG(__FILE__, __LINE__, "midStr: $midStr");
if (preg_match("/(S[0-9]{9}) /", $midStr, $arr)) {
	$manager_id = substr($midStr, 0, 10);
}
DEBUG(__FILE__, __LINE__, "manager_id: $manager_id");

try {
        if ($department_id <= 0) throw new Exception('無效的部門編號');

	$init_phonetic = '';
	$init_pinyin   = '';

	if (getPhoneticMap($conn, $phoneticMap) === false) {
		$phoneticMap = [];
	}
	DEBUG(__FILE__, __LINE__, "phoneticMap Count: " . count($phoneticMap));

	if (count($phoneticMap)) {
		if (getInitPhonetic($phoneticMap, $name, $phonetic, $pinyin) !== false) {
			DEBUG(__FILE__, __LINE__, "phonetic: $phonetic, pinyin: $pinyin");
			$init_phonetic = $phonetic;
			$init_pinyin = $pinyin;
			DEBUG(__FILE__, __LINE__, "init_phonetic: $init_phonetic, init_pinyin: $init_pinyin");
		}
	}
	DEBUG(__FILE__, __LINE__, "phonetic: $init_phonetic, pinyin: $init_pinyin");

	DEBUG(__FILE__, __LINE__, "SQL: UPDATE DEPARTMENTS SET name='$name', en_name='$en_name', phonetic='$init_phonetic', pinyin='$init_pinyin', parent_dept='$parent_dept', manager_id='$manager_id', extension='$extension' WHERE department_id=$department_id");

        $sql = "UPDATE DEPARTMENTS SET name = ?, en_name = ?, phonetic = ?, pinyin = ?,
			parent_dept = ?, manager_id = ?, extension = ?,
			created_at = created_at, updated_at = now()
		WHERE department_id = ?";

        $stmt = $conn->prepare($sql);
	$stmt->bind_param('ssssissi', $name, $en_name, $init_phonetic, $init_pinyin,
	       	$parent_dept, $manager_id, $extension, $department_id);
        $stmt->execute();

        $ret = true;
        $msg = '更新成功';

} catch (Throwable $e) {
        $msg = $e->getMessage();
}

logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret,'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "MSG: $msg");

echo json_encode(['result'=>$ret,'msg'=>$msg]);
