<?php

include '../config.php';
if (session_status() == PHP_SESSION_NONE)
	session_start();

$ret = false;
$data = NULL;
$msg = '';
$args = [];

$tbl = 'EMPLOYEES';

header('Content-Type: application/json');

// 確保請求方法為 POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
	$msg = '無效的網頁請求';
} else {
	// 讀取 POST 的 JSON 數據
	$queryStr = file_get_contents('php://input');

	DEBUG(__FILE__, __LINE__, "queryStr: ".$queryStr);

	$arr = json_decode($queryStr, true);
	$args = $arr;

	// 檢查是否有接收到 employee_id
	$sid = $arr['id'] ?? null;
	if (!$sid) {
		$msg = '缺少 employee id';
	} else {
		// 提取 EMPLOYEES 的資料
		$init_phonetic = '';
		$init_pinyin = '';
		$login_id           = intval($queryArr['login_id'] ?? 0); // 00. login_id
		$cname              = $args['cname']              ?? ''; // 01. cname
		$ename              = $args['ename']              ?? ''; // 02. ename
		$gender             = $args['gender']             ?? ''; // 03. gender
		$birth_date         = $args['birth_date']         ?? ''; // 04. birth_date
		$blood_type         = $args['blood_type']         ?? ''; // 05. blood_type
		$nationality        = $args['nationality']        ?? ''; // 06. nationality
		$marital_status     = $args['marital_status']     ?? ''; // 07. marital_status
		$hire_date          = $args['hire_date']          ?? ''; // 08. hire_date
		$national_id_type   = $args['national_id_type']   ?? ''; // 09. national_id_type
		$national_id        = $args['national_id']        ?? ''; // 10. national_id
		$mobile_phone       = $args['mobile_phone']       ?? ''; // 11. mobile_phone
		$home_phone         = $args['home_phone']         ?? ''; // 12. home_phone
		$work_phone         = $args['work_phone']         ?? ''; // 13. work_phone
		$email              = $args['email']              ?? ''; // 14. email
		$address_country    = $args['address_country']    ?? ''; // 15. address_country
		$address_city       = $args['address_city']       ?? ''; // 16. address_city
		$address_district   = $args['address_district']   ?? ''; // 17. address_district
		$address_postcode   = $args['address_postcode']   ?? ''; // 18. address_postcode
		$address_detail     = $args['address_detail']     ?? ''; // 19. address_detail
		$emergency_name     = $args['emergency_name']     ?? ''; // 20. emergency_name
		$emergency_relation = $args['emergency_relation'] ?? ''; // 21. emergency_relation
		$emergency_phone    = $args['emergency_phone']    ?? ''; // 22. emergency_phone
		$education_level    = $args['education_level']    ?? ''; // 23. education_level
		$graduation_year    = $args['graduation_year']    ?? ''; // 24. graduation_year
		$graduated_from     = $args['graduated_from']     ?? ''; // 25. graduated_from
		$major              = $args['major']              ?? ''; // 26. major
		$work_experience    = $args['work_experience']    ?? ''; // 27. work_experience
		$jobtitle_id        = intval($args['jobtitle_id'] ?? 0); // 28. jobtitle_id
		$department_id      = intval($args['department_id'] ?? 0); // 29. department_id
		DEBUG(__FILE__, __LINE__, "QUERY: ".json_encode($args));
		DEBUG(__FILE__, __LINE__, "birth_date: $birth_date");

		if (getPhoneticMap($conn, $phoneticMap) === false) {
			$phoneticMap = [];
		}

		if (count($phoneticMap)) {
			if (getInitPhonetic($phoneticMap, $cname, $phonetic, $pinyin) !== false) {
				$init_phonetic = $phonetic;
				$init_pinyin = $pinyin;
			}
		}

		try {
			// 鎖定 $tbl 表，避免其他進程同時操作
			$conn->query("LOCK TABLES $tbl WRITE");

			// 更新 EMPLOYEES 表
			$stmt = $conn->prepare("
						UPDATE $tbl
						SET cname = ?, phonetic = ?, pinyin = ?, ename = ?, gender = ?, birth_date = ?, blood_type = ?, nationality = ?,
							marital_status = ?, hire_date = ?, national_id_type = ?, national_id = ?, mobile_phone = ?,
							home_phone = ?, work_phone = ?, email = ?, address_country = ?, address_city = ?, address_district = ?,
							address_postcode = ?, address_detail = ?, emergency_name = ?, emergency_relation = ?, emergency_phone = ?,
							education_level = ?, graduation_year = ?, graduated_from = ?, major = ?, work_experience = ?,
							jobtitle_id = ?, department_id = ?, created_at = created_at, updated_at = now()
						WHERE employee_id = ?
						");
			$stmt->bind_param('sssssssssssssssssssssssssssssiis',
				$cname, $init_phonetic, $init_pinyin, $ename, $gender, $birth_date, $blood_type, $nationality,
				$marital_status, $hire_date, $national_id_type, $national_id, $mobile_phone, $home_phone, $work_phone,
				$email, $address_country, $address_city, $address_district, $address_postcode, $address_detail,
				$emergency_name, $emergency_relation, $emergency_phone,	$education_level, $graduation_year, $graduated_from, $major,
				$work_experience, $jobtitle_id, $department_id, $sid);
			if (!$stmt->execute()) {
				throw new Exception("更新 $tbl 失敗: " . $stmt->error);
			}

			// 解除表鎖定
			$conn->query("UNLOCK TABLES");
			$ret = true;
			$msg = "員工 '$sid' 已成功更新";
		} catch (Exception $e) {
			// 捕捉任何錯誤，返回錯誤訊息
			$msg = $e->getMessage();
		}
	}
}
DEBUG(__FILE__, __LINE__, "MSG: ".$msg);
logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret, 'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "Ret: ".json_encode($data));
echo json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]);

?>

