<?php
require_once __DIR__ . '/../config.php';

if (session_status() == PHP_SESSION_NONE)
	session_start();

$args = json_decode(file_get_contents('php://input'), true);

$ret  = false;
$msg  = '';
$data = null;
$tbl  = 'JOBTITLES';

/* ========= DEBUG: 取得參數 ========= */
DEBUG(__FILE__, __LINE__, 'ARGS: ' . json_encode($args));

$position_id  = intval($args['position_id'] ?? 0);
$title        = $args['title'] ?? '';
$en_title     = $args['en_title'] ?? '';
$category     = $args['category'] ?? '';
$salary_range = $args['salary_range'] ?? '';

if (!$args || !$position_id || !strlen($title) || !strlen($en_title) || !strlen($category)) {
	$msg = '缺少必要欄位';
} else {
	$init_phonetic = '';
	$init_pinyin   = '';

	if (getPhoneticMap($conn, $phoneticMap) === false) {
		$phoneticMap = [];
	}
	DEBUG(__FILE__, __LINE__, "phoneticMap Count: " . count($phoneticMap));

	if (count($phoneticMap)) {
		if (getInitPhonetic($phoneticMap, $title, $phonetic, $pinyin) !== false) {
			DEBUG(__FILE__, __LINE__, "phonetic: $phonetic, pinyin: $pinyin");
			$init_phonetic = $phonetic;
			$init_pinyin = $pinyin;
			DEBUG(__FILE__, __LINE__, "init_phonetic: $init_phonetic, init_pinyin: $init_pinyin");
		}
	}
	DEBUG(__FILE__, __LINE__, "phonetic: $init_phonetic, pinyin: $init_pinyin");

	try {
		// 鎖定 $tbl 表，避免其他進程同時操作
		$conn->query("LOCK TABLES $tbl WRITE");
		
		DEBUG(__FILE__, __LINE__, "UPDATE $tbl SET title='$title',en_title='$en_title',phonetic='$init_phonetic',pinyin='$init_pinyin',category='$category',salary_range='$salary_range' WHERE position_id=$position_id");

		$stmt = $conn->prepare("UPDATE $tbl
			SET title = ?, en_title = ?, phonetic = ?, pinyin = ?, category = ?,
				salary_range = ?, created_at = created_at, updated_at = now()
			WHERE position_id = ?");
		$stmt->bind_param('ssssssi', $title, $en_title, $init_phonetic, $init_pinyin, $category, $salary_range, $position_id);
		if (!$stmt->execute()) {
			throw new Exception("更新 $tbl 失敗: " . $stmt->error);
		}

		// 解除表鎖定
		$conn->query("UNLOCK TABLES");
		$ret = true;
		$msg = '職稱更新成功';

	} catch (Exception $e) {
		$msg = '更新失敗：' . $e->getMessage();
	}
}

/* ========= DEBUG & LOG ========= */
DEBUG(__FILE__, __LINE__, "MSG: $msg");

logAction(
	$conn,
	__FILE__,
	'',
	$args,
	json_encode(['result'=>$ret, 'msg'=>$msg])
);

DEBUG(__FILE__, __LINE__, 'Ret: ' . json_encode($data));

echo json_encode([
	'result' => $ret,
	'data'   => $data,
	'msg'    => $msg
]);

