<?php
require_once __DIR__ . '/../config.php';
if (session_status() == PHP_SESSION_NONE) session_start();

$ret = false;
$msg = '';
$data = ['ttl'     => 0, 'page'    => 1, 'records' => []];

try {
	$date = $_GET['date'] ?? '';
	if (!$date) {
		throw new Exception('Missing date parameter');
	}

	// ===== 你的既有 SQL（只做欄位 alias）=====
	$sql = "
	SELECT DISTINCT 
		e.employee_id AS doctor_id, e.cname AS name
	FROM EMPLOYEES e
		JOIN JOBTITLES j ON e.jobtitle_id = j.position_id
		JOIN clinic_scheduling s ON s.staff_id = e.employee_id
	WHERE j.en_title = 'doctor' AND s.staff_role = j.position_id
		AND s.work_date = ? AND s.status = 'active'
	ORDER BY e.employee_id
	";

	$stmt = $conn->prepare($sql);
	if (!$stmt) {
		throw new Exception($conn->error);
	}

	$stmt->bind_param('s', $date);
	$stmt->execute();

	$result = $stmt->get_result();
	while ($row = $result->fetch_assoc()) {
		$data['records'][] = $row;
	}

	$data['ttl'] = count($data['records']);
	$ret = true;
	$msg = 'OK';
} catch (Throwable $e) {
	// 不讓 PHP fatal，確保一定回 JSON
	$msg = $e->getMessage();
}

DEBUG(__FILE__, __LINE__, "MSG: $msg");
logAction($conn, __FILE__, '', [], json_encode(['result'=>$ret,'msg'=>$msg]));
echo json_encode([
	'result' => $ret,
	'data'   => $data,
	'msg'    => $msg
], JSON_UNESCAPED_UNICODE);

