<?php
require_once __DIR__ . '/../config.php';

/* ===================== 時段重疊檢查 ===================== */
function checkTimeOverlap($conn, $staff_id, $work_date, $start_time, $end_time, $exclude_id = null) {

    $sql = "
        SELECT COUNT(*) AS cnt
        FROM clinic_scheduling
        WHERE staff_id = ?
          AND work_date = ?
          AND status = 'active'
          AND (? < end_time AND ? > start_time)
    ";

    if ($exclude_id !== null) {
        $sql .= " AND id != ?";
    }

    $stmt = $conn->prepare($sql);

    if ($exclude_id !== null) {
        $stmt->bind_param(
            'ssssi',
            $staff_id,
            $work_date,
            $start_time,
            $end_time,
            $exclude_id
        );
    } else {
        $stmt->bind_param(
            'ssss',
            $staff_id,
            $work_date,
            $start_time,
            $end_time
        );
    }

    $stmt->execute();
    $res = $stmt->get_result()->fetch_assoc();

    return intval($res['cnt']) > 0;
}

/* ===================== Audit Log ===================== */
function logSchedulingAudit($conn, $sid, $action, $before, $after) {
    $sql = "
        INSERT INTO clinic_scheduling_audit
        (scheduling_id, action, before_data, after_data)
        VALUES (?, ?, ?, ?)
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        'isss',
        $sid,
        $action,
        $before ? json_encode($before, JSON_UNESCAPED_UNICODE) : null,
        $after  ? json_encode($after,  JSON_UNESCAPED_UNICODE) : null
    );
    $stmt->execute();
}

