<?php
require_once __DIR__ . '/../config.php';

if (!function_exists('DEBUG')) { function DEBUG() {} }
if (!function_exists('logAction')) { function logAction() {} }

$args = json_decode(file_get_contents('php://input'), true);
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

$ret = false;
$msg = '';

try {
	// ===== 依 shift_id 取得班別名稱（方案 A 核心）=====
	if (empty($args['shift_id'])) {
		throw new Exception('未指定班別');
	}

	$stmt = $conn->prepare("SELECT shift_name FROM clinic_shift_settings WHERE id = ? AND is_active = 1");
	
	DEBUG(__FILE__, __LINE__, "SQL: SELECT shift_name FROM clinic_shift_settings WHERE id = ? AND is_active = 1");

	$stmt->bind_param('i', $args['shift_id']);
	$stmt->execute();
	$res = $stmt->get_result();
	$row = $res->fetch_assoc();
	$stmt->close();

	if (!$row) {
		throw new Exception('班別不存在或已停用');
	}

	$shift_name = $row['shift_name'];   // ★ 後端決定 shift_name


	/* ===== 重疊檢查 ===== */
	$sql = "
	SELECT COUNT(*) AS cnt
	FROM clinic_scheduling
	WHERE staff_id = ?
	  AND work_date = ?
	  AND shift_id = ?
	  AND status = 'active'
	  AND (? < end_time AND ? > start_time)
    ";

	DEBUG(__FILE__, __LINE__, "SQL: $sql");

	$stmt = $conn->prepare($sql);
	if (!$stmt) throw new Exception($conn->error);

	$stmt->bind_param(
		'sisss',
		$args['staff_id'],
		$args['shift_id'],
		$args['work_date'],
		$args['start_time'],
		$args['end_time']
	);
	$stmt->execute();
	$res = $stmt->get_result()->fetch_assoc();
	$stmt->close();

	if ($res['cnt'] > 0) {
		throw new Exception('該人員於此時段已有排班');
	}

	/* ===== 新增 ===== */
	$sql = "
	INSERT INTO clinic_scheduling
	(staff_id, staff_role, work_date, shift_id, shift_name, start_time, end_time, remark)
	VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ";

	DEBUG(__FILE__, __LINE__, "SQL: $sql");

	$stmt = $conn->prepare($sql);
	if (!$stmt) throw new Exception($conn->error);

	$stmt->bind_param(
		'sisissss',
		$args['staff_id'],
		intval($args['staff_role']),
		$args['work_date'],
		intval($args['shift_id']),
		$shift_name,
		$args['start_time'],
		$args['end_time'],
		$args['remark']
	);

	$ret = $stmt->execute();
	$stmt->close();

	$msg = $ret ? '新增排班成功' : '新增排班失敗';

} catch (Exception $e) {
	$msg = $e->getMessage();
}

logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret,'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "MSG: " . $msg);
echo json_encode(['result'=>$ret,'msg'=>$msg]);

