<?php
require_once __DIR__ . '/../config.php';

if (!function_exists('DEBUG')) { function DEBUG() {} }
if (!function_exists('logAction')) { function logAction() {} }

$args = $_GET;
DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

$ret = true;
$msg = '';
$data = [
    'ttl' => 0,
    'records' => []
];

try {
    $sql = "SELECT employee_id, cname FROM EMPLOYEES ORDER BY cname";
    $stmt = $conn->prepare($sql);
    if (!$stmt) throw new Exception($conn->error);

    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $data['records'][] = $row;
    }

    $data['ttl'] = count($data['records']);
    $stmt->close();

} catch (Exception $e) {
    $ret = false;
    $msg = $e->getMessage();
}

logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret,'msg'=>$msg]));
echo json_encode(['result'=>$ret,'data'=>$data,'msg'=>$msg]);

