<?php
include '../config.php';
if (session_status() == PHP_SESSION_NONE) session_start();

$ret = false;
$data = NULL;
$msg = '取消掛號失敗';
$args = [];

header('Content-Type: application/json');

try {
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

    $raw = file_get_contents('php://input');
    $args = json_decode($raw, true);
    if (!is_array($args)) $args = [];

    DEBUG(__FILE__, __LINE__, "ARGS: " . json_encode($args));

    $ids = isset($args['ids']) ? $args['ids'] : [];
    if (!is_array($ids) || count($ids) === 0) throw new Exception("缺少 ids");

    // 清理 ids
    $clean = [];
    foreach ($ids as $v) {
        $iv = intval($v);
        if ($iv > 0) $clean[] = $iv;
    }
    if (count($clean) === 0) throw new Exception("ids 無效");

    // 以取消為主（不真的刪除）
    $placeholders = implode(',', array_fill(0, count($clean), '?'));
    $types = str_repeat('i', count($clean));

    $sql = "UPDATE APPOINTMENTS SET status='取消' WHERE id IN ($placeholders)";
    $stmt = $conn->prepare($sql);
    if ($stmt === FALSE) throw new Exception('資料庫查詢準備失敗: ' . $conn->error);

    $stmt->bind_param($types, ...$clean);
    $stmt->execute();
    $affected = $stmt->affected_rows;
    $stmt->close();

    $data = ['affected' => $affected, 'ids' => $clean];
    $ret = true;
    $msg = '';
} catch (Exception $e) {
    $msg = $e->getMessage();
}

DEBUG(__FILE__, __LINE__, "MSG: $msg");
logAction($conn, __FILE__, '', $args, json_encode(['result'=>$ret, 'msg'=>$msg]));
DEBUG(__FILE__, __LINE__, "Ret: ".json_encode($data));
echo json_encode(['result'=>$ret, 'data'=>$data, 'msg'=>$msg]);
?>

