/* =========================================================
 * Job Titles Module
 * 職稱設定（buttom-widget）
 * ========================================================= */

document.addEventListener('DOMContentLoaded', () => {
    loadJobTitles();

    document.getElementById('chkJobTitleAll')
        ?.addEventListener('change', e => {
            document.querySelectorAll('.chk-jobtitle')
                .forEach(chk => chk.checked = e.target.checked);
        });
});

/* ===== 載入列表 ===== */
function loadJobTitles() {
    fetch('/api/employees/get_jobtitles.php')
        .then(res => res.json())
        .then(json => {
            if (!json.result) {
                alert(json.msg);
                return;
            }

            const tbody = document.querySelector('#jobtitles-table tbody');
            if (!tbody) return;

            tbody.innerHTML = '';

            json.data.records.forEach(row => {
                const tr = document.createElement('tr');
                tr.dataset.id = row.position_id;

                tr.innerHTML = `
                    <td><input type="checkbox" class="chk-jobtitle"></td>
                    <td>${row.title}</td>
                    <td>${row.en_title}</td>
                    <td>${row.category}</td>
                `;

                tr.addEventListener('click', e => {
                    if (e.target.tagName === 'INPUT') return;
                    loadJobTitleDetail(row.position_id);
                });

                tbody.appendChild(tr);
            });
        });
}

/* ===== 讀取單筆 ===== */
async function loadJobTitleDetail(positionId) {
    const res = await fetch(
        `/api/employees/get_jobtitle.php?position_id=${positionId}`
    );
    const json = await res.json();

    if (!json.result) {
        alert(json.msg);
        return;
    }

    const d = json.data;
    const dlg = document.getElementById('jobtitleDialog');

    dlg.dataset.id = d.position_id;
    document.getElementById('jobTitleInput').value    = d.title;
    document.getElementById('jobEnTitleInput').value  = d.en_title;
    document.getElementById('jobPhoneticInput').value = d.phonetic;
    document.getElementById('jobPinyinInput').value   = d.pinyin;
    document.getElementById('jobCategorySelect').value = d.category;
    document.getElementById('jobSalaryInput').value   = d.salary_range ?? '';

    dlg.showModal();
}

/* ===== 更新 ===== */
async function updateJobTitle() {
    const dlg = document.getElementById('jobtitleDialog');

    const payload = {
        position_id: dlg.dataset.id,
        title: document.getElementById('jobTitleInput').value.trim(),
        en_title: document.getElementById('jobEnTitleInput').value.trim(),
        phonetic: document.getElementById('jobPhoneticInput').value.trim(),
        pinyin: document.getElementById('jobPinyinInput').value.trim(),
        category: document.getElementById('jobCategorySelect').value,
        salary_range: document.getElementById('jobSalaryInput').value.trim()
    };

    const res = await fetch('/api/employees/update_jobtitle.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(payload)
    });

    const json = await res.json();
    alert(json.msg);

    if (json.result) {
        dlg.close();
        loadJobTitles();
    }
}

/* ===== 多選刪除 ===== */
function getSelectedJobTitleIds() {
    return Array.from(
        document.querySelectorAll('.chk-jobtitle:checked')
    ).map(chk => chk.closest('tr').dataset.id);
}

async function deleteSelectedJobTitles() {
    const ids = getSelectedJobTitleIds();

    if (ids.length === 0) {
        alert('請先選擇要刪除的職稱');
        return;
    }

    if (!confirm(`確定要刪除 ${ids.length} 筆職稱？`)) return;

    const res = await fetch('/api/employees/del_jobtitles.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ position_ids: ids })
    });

    const json = await res.json();

    if (!json.result) {
        alert(json.msg);
        return;
    }

    let msg = `成功刪除 ${json.data.deleted_count} 筆職稱。`;

    if (json.data.blocked_ids.length > 0) {
        msg += `\n以下職稱因已有員工使用，無法刪除：\n`;
        msg += json.data.blocked_ids.join(', ');
    }

    alert(msg);
    loadJobTitles();
}

