(function () {
    async function requireLogin() {
        try {
            const res = await fetch('/api/session-check.php', {
                method: 'GET',
                credentials: 'include'
            });

            if (!res.ok) {
                throw new Error('HTTP ' + res.status);
            }

            const data = await res.json();
            if (!data.result) {
                throw new Error(data.msg || '未登入');
            }

            // 從後端回來的資訊塞回全域變數，給其他 JS 用
            if (data.data) {
                window.currentUsername   = data.data.username;
                window.currentUserName   = data.data.name || data.data.username;
                window.currentUserGrade  = data.data.grade || null;
                window.currentUserRole   = data.data.role  || null;
            }
        } catch (e) {
            alert('登入逾時或尚未登入，請重新登入。');
            // 嘗試通知後端登出（可有可無）
            fetch('/api/logout.php', { method: 'POST' }).catch(() => {});
            window.location.href = '/login.html';
        }
    }

    // 掛在全域，讓其他 JS 想重檢查時也可以呼叫
    window.requireLogin = requireLogin;

    // 一載入就先檢查一次
    requireLogin();
})();

