<?php
/**
 * 產生一個 5 碼的登入驗證碼，並將其與 60 秒的到期時間 存入 Session。
 */
session_start();

// 規則: 自動產生一個 5 碼的驗證碼 [cite: 30]
$code = (string)rand(10000, 99999);

// 規則: 有效時間為60秒 [cite: 30]
$expires = time() + 60; 

// 存入 Session
$_SESSION['loginCode'] = $code;
$_SESSION['loginCodeExpires'] = $expires;

// 設置回應標頭為 JSON
header('Content-Type: application/json');

// 將驗證碼回傳給前端 (login.js) 顯示
echo json_encode(['code' => $code]);
?>
