<?php
session_start();
include 'db_connect.php'; 
include 'log_helper.php';

header('Content-Type: application/json');

$input   = json_decode(file_get_contents('php://input'), true);
$account = trim($input['account'] ?? '');
$code    = trim($input['code'] ?? '');

// === 驗證碼檢查 ===
if (!isset($_SESSION['loginCode']) || $code !== $_SESSION['loginCode']) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => '驗證碼錯誤']);
    exit;
}
if (time() > ($_SESSION['loginCodeExpires'] ?? 0)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => '驗證碼已失效，請重置']);
    exit;
}

try {
    $pdo = get_db_connection();
    
    // 讀取使用者資料（含 class）【原本就有】:contentReference[oaicite:1]{index=1}
    $stmt = $pdo->prepare(
        "SELECT id, username, name, role, grade, is_active, class 
         FROM users 
         WHERE username = ?"
    );
    $stmt->execute([$account]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => '帳號不存在']);
        exit;
    }
    if (!$user['is_active']) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => '此帳號已失效，無法登入']);
        exit;
    }

    // 驗證碼用完即丟
    unset($_SESSION['loginCode'], $_SESSION['loginCodeExpires']);

    // === 學生：維持原本機制，直接登入 ===
    if ($user['role'] === 'student') {
        $_SESSION['user'] = [
            'id'       => $user['id'],
            'username' => $user['username'],
            'name'     => $user['name'],
            'role'     => $user['role'],
            'grade'    => $user['grade'],
            'class'    => $user['class'],
        ];

        log_operation($pdo, $user['id'], $user['username'], 'USER_LOGIN');

        echo json_encode([
            'success' => true,
            'role'    => 'student',
            'needPassword' => false,
        ]);
        exit;
    }

    // === 管理者 / 教師：只通過第一階段，改走密碼驗證 ===
    $_SESSION['pending_user_id'] = $user['id'];

    echo json_encode([
        'success'      => true,
        'needPassword' => true,
        'role'         => $user['role'],
        'username'     => $user['username'],
        'name'         => $user['name'],
        'message'      => '請輸入管理者／教師密碼完成登入'
    ]);
} catch (\PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => '資料庫連線錯誤: ' . $e->getMessage()]);
}

