CREATE TABLE bulletin_posts (
    id              INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    title           VARCHAR(100) NOT NULL COMMENT '公告標題（可選）',
    content         TEXT NOT NULL COMMENT '訊息內容',
    type            ENUM('event', 'general', 'system', 'other') NOT NULL DEFAULT 'general' COMMENT '訊息類型',
    start_at        DATETIME NOT NULL COMMENT '公告開始日期時間',
    end_at          DATETIME NOT NULL COMMENT '公告結束日期時間',
    attachment_path VARCHAR(255) DEFAULT NULL COMMENT '附檔路徑',
    attachment_usage VARCHAR(100) DEFAULT NULL COMMENT '附檔用途說明',
    link_url        VARCHAR(255) DEFAULT NULL COMMENT '相關連結',
    created_by      INT UNSIGNED NOT NULL COMMENT '建立者 user_id',
    created_at      DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_at      DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    is_active       TINYINT(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='佈告欄公告';

CREATE TABLE typing_activities (
    id              INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    type            ENUM('test','contest') NOT NULL COMMENT '活動型態：測驗/比賽',
    title           VARCHAR(100) NOT NULL COMMENT '活動名稱',
    description     TEXT NULL COMMENT '活動說明',
    start_at        DATETIME NOT NULL COMMENT '開始日期時間',
    end_at          DATETIME NOT NULL COMMENT '結束日期時間',
    -- 打字設定（依你現有練習模式需要的欄位調整）
    mode            ENUM('time','text') NOT NULL DEFAULT 'time' COMMENT '計時/定字數模式',
    duration_sec    INT UNSIGNED DEFAULT NULL COMMENT '計時模式秒數',
    text_source     TEXT NULL COMMENT '題目文字，或題庫代號',
    max_attempts    INT UNSIGNED NOT NULL DEFAULT 3 COMMENT '每帳號可測試次數；比賽設成 1',
    created_by      INT UNSIGNED NOT NULL COMMENT '建立者 user_id',
    result_published_at DATETIME NULL COMMENT '成績公布時間，NULL 表示未公布',
    created_at      DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_at      DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='打字活動（測驗/比賽）';

CREATE TABLE typing_results (
    id              BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    user_id         INT UNSIGNED NOT NULL,
    activity_id     INT UNSIGNED DEFAULT NULL COMMENT '對應 typing_activities.id；練習模式可為 NULL',
    mode            ENUM('practice','test','contest') NOT NULL DEFAULT 'practice',
    started_at      DATETIME NOT NULL,
    finished_at     DATETIME NOT NULL,
    duration_ms     INT UNSIGNED NOT NULL,
    char_count      INT UNSIGNED NOT NULL COMMENT '總輸入字數',
    error_count     INT UNSIGNED NOT NULL COMMENT '錯誤字數',
    wpm             DECIMAL(6,2) NOT NULL COMMENT '每分鐘字數',
    accuracy        DECIMAL(5,2) NOT NULL COMMENT '正確率 %',
    raw_score       INT NOT NULL COMMENT '活動用的分數（可依 wpm/accuracy 算）',
    created_at      DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    KEY idx_user_activity (user_id, activity_id),
    KEY idx_activity (activity_id),
    CONSTRAINT fk_results_activity FOREIGN KEY (activity_id)
        REFERENCES typing_activities(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='打字成績紀錄';

