<?php
// 檢查登入狀態並回傳使用者資訊
session_start();

header('Content-Type: application/json');

if (isset($_SESSION['user'])) {
    // 已登入，回傳使用者資訊 (包含 id, name, class)
    echo json_encode([
        'loggedIn' => true,
        'id' => $_SESSION['user']['id'],
        'username' => $_SESSION['user']['username'],
        'name' => $_SESSION['user']['name'],
        'role' => $_SESSION['user']['role'],
        'class' => $_SESSION['user']['class']
    ]);
} else {
    // 未登入
    http_response_code(401);
    echo json_encode(['loggedIn' => false, 'message' => '未授權']);
}

