<?php
session_start();
include 'db_connect.php'; 
include 'log_helper.php'; // 載入 Log [cite: 5]

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$account = $input['account'] ?? '';
$code = $input['code'] ?? '';

// 驗證碼檢查 [cite: 30, 31]
if (!isset($_SESSION['loginCode']) || $code !== $_SESSION['loginCode']) {
    http_response_code(400);
    echo json_encode(['message' => '驗證碼錯誤']);
    exit;
}
if (time() > $_SESSION['loginCodeExpires']) {
    http_response_code(400);
    echo json_encode(['message' => '驗證碼已失效，請重置']);
    exit;
}

try {
    $pdo = get_db_connection();
    
    // 讀取 `class` 欄位 [cite: 2]
    $stmt = $pdo->prepare("SELECT id, username, name, role, grade, is_active, class FROM users WHERE username = ?");
    $stmt->execute([$account]);
    $user = $stmt->fetch();

    if (!$user) {
        http_response_code(404);
        echo json_encode(['message' => '帳號不存在']);
        exit;
    }
    if (!$user['is_active']) { // [cite: 28]
        http_response_code(403);
        echo json_encode(['message' => '此帳號已失效，無法登入']);
        exit;
    }

    unset($_SESSION['loginCode']);
    unset($_SESSION['loginCodeExpires']);

    // 將 `class` 存入 Session [cite: 2]
    $_SESSION['user'] = [
        'id' => $user['id'],
        'username' => $user['username'],
        'name' => $user['name'],
        'role' => $user['role'],
        'grade' => $user['grade'],
        'class' => $user['class'] //
    ];
    
    // 寫入登入日誌 [cite: 5]
    log_operation($pdo, $user['id'], $user['username'], 'USER_LOGIN');

    echo json_encode(['success' => true]);

} catch (\PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => '資料庫連線錯誤: ' . $e->getMessage()]);
}
?>
