document.addEventListener("DOMContentLoaded", () => {
    const codeDisplay = document.getElementById("code-display");
    const timerDisplay = document.getElementById("timer");
    const loginForm = document.getElementById("login-form");
    const loginButton = document.getElementById("login-button");
    const resetButton = document.getElementById("reset-code-btn");
    const messageArea = document.getElementById("message-area");
    const accountInput = document.getElementById("account");
    const codeInput = document.getElementById("verification-code");

    let timer;
    let secondsLeft = 60;

    // 1. 獲取新驗證碼 (加入更完整的錯誤處理)
    async function fetchNewCode() {
        // 重置狀態，顯示載入中
        codeDisplay.textContent = "...";
        messageArea.textContent = "";
        loginButton.disabled = true; // 載入中先禁用
        
        try {
            const response = await fetch('api/generate-code.php');
            
            if (!response.ok) {
                // 處理 404 或 500 錯誤
                throw new Error(`API 錯誤: ${response.status} ${response.statusText}`);
            }
            
            const data = await response.json();
            
            if (data.code) {
                codeDisplay.textContent = data.code;
                startTimer(); // 只有成功才啟動計時器
            } else {
                throw new Error('API 未回傳 code');
            }
            
        } catch (err) {
            // 捕獲 fetch 失敗 或 JSON 解析失敗
            console.error("fetchNewCode 失敗:", err);
            messageArea.textContent = "無法取得驗證碼，請檢查 API。";
            timerDisplay.textContent = "計時器停止";
            codeDisplay.textContent = "Error";
            loginButton.disabled = true; // 保持禁用
            resetButton.disabled = false; // 允許重置
        }
    }

    // 2. 啟動計時器
    function startTimer() {
        secondsLeft = 60; 
        timerDisplay.textContent = `驗證碼將於 ${secondsLeft} 秒後失效`;
        timerDisplay.style.color = "#dc3545";
        
        loginButton.disabled = false;    // 成功取得 code 後，啟用登入
        resetButton.disabled = true;
        messageArea.textContent = "";

        clearInterval(timer); 
        timer = setInterval(() => {
            secondsLeft--;
            timerDisplay.textContent = `驗證碼將於 ${secondsLeft} 秒後失效`;

            if (secondsLeft <= 0) {
                clearInterval(timer);
                timerDisplay.textContent = "驗證碼已失效";
                timerDisplay.style.color = "#555";
                codeDisplay.textContent = "-----";
                loginButton.disabled = true;
                resetButton.disabled = false;
                messageArea.textContent = "驗證碼已失效，請點擊重置。";
            }
        }, 1000);
    }

    // 3. 綁定重置按鈕
    resetButton.addEventListener('click', fetchNewCode);

    // 4. 處理表單提交
    loginForm.addEventListener("submit", async (e) => {
        e.preventDefault(); 
        
        const account = accountInput.value;
        const code = codeInput.value;

        if (!account || !code) {
            messageArea.textContent = "帳號和驗證碼皆須填寫";
            return;
        }

        messageArea.textContent = "";
        loginButton.disabled = true; // 提交中禁用

        try {
            const response = await fetch('api/login.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ 
                    account: account, 
                    code: code 
                })
            });

            const data = await response.json();

            if (response.ok) {
                // 登入成功
                messageArea.textContent = "登入成功！正在導向...";
                messageArea.className = "success"; 
                clearInterval(timer);
                
                setTimeout(() => {
                    window.location.href = 'dashboard.html'; 
                }, 1000);
            } else {
                // 登入失敗 (驗證碼錯誤, 帳號不存在, 帳號失效)
                messageArea.textContent = data.message;
                loginButton.disabled = false; // 允許重試
            }
        } catch (err) {
            console.error("登入 API 失敗:", err);
            messageArea.textContent = "登入時發生網路錯誤，請稍後再試。";
            loginButton.disabled = false;
        }
    });

    // 初始載入
    fetchNewCode();
});
