<?php
session_start();
include 'db_connect.php'; 
include 'log_helper.php'; // 載入 Log [cite: 5]

if (isset($_SESSION['user'])) {
    $user = $_SESSION['user'];
    
    // 登出前寫入 Log [cite: 5]
    try {
        $pdo = get_db_connection();
        log_operation($pdo, $user['id'], $user['username'], 'USER_LOGOUT');
    } catch (\Exception $e) {
        // 寫入失敗不應阻擋登出
        error_log('Failed to log logout: ' . $e->getMessage());
    }
}

session_unset();
session_destroy();

header('Content-Type: application/json');
echo json_encode(['success' => true]);

