<?php
// 檢查登入狀態並回傳使用者資訊
session_start();

header('Content-Type: application/json; charset=utf-8');

if (isset($_SESSION['user'])) {
    $u = $_SESSION['user'];

    echo json_encode([
        'loggedIn' => true,
        'id'       => $u['id'],
        'username' => $u['username'],
        'name'     => $u['name'],
        'role'     => $u['role'],
        'class'    => $u['class'],
        'grade'    => $u['grade'] ?? null,   // ★ 新增：年級
    ]);
} else {
    // 未登入
    http_response_code(401);
    echo json_encode([
        'loggedIn' => false,
        'message'  => '未授權'
    ]);
}

