// typing-report.js — 個人歷史成績（列表 + 折線圖）
(function(){
  const start = document.getElementById('start');
  const end = document.getElementById('end');
  const btn = document.getElementById('btnQuery');
  const stat = document.getElementById('stat');
  const listBody = document.getElementById('listBody');
  const msg = document.getElementById('msg');
  const inlineStatus = document.getElementById('inlineStatus');
  const ctx = document.getElementById('wpmChart');
  let chart;

  function fmt(ts){
    const d = new Date(ts);
    const p = n=>String(n).padStart(2,'0');
    return `${d.getFullYear()}-${p(d.getMonth()+1)}-${p(d.getDate())} ${p(d.getHours())}:${p(d.getMinutes())}`;
  }

  async function query(){
    inlineStatus.textContent = '';
    msg.textContent=''; listBody.innerHTML='<tr><td colspan="9">載入中...</td></tr>';
    try{
      const qs = [];
      if (start.value) qs.push('start='+encodeURIComponent(start.value));
      if (end.value)   qs.push('end='  +encodeURIComponent(end.value));
      const url = 'api/typing_practice.php?action=personal' + (qs.length?('&'+qs.join('&')):'');
      const res = await fetch(url, { credentials: 'include', cache:'no-store' });
      const data = await res.json();
      if (!res.ok || !data.success) throw new Error(data.message || '讀取失敗');

      // summary
      const s = data.summary || {};
      stat.textContent = `筆數：${s.cnt || 0}，平均 WPM：${s.avg_wpm ?? '-'}，最高：${s.max_wpm ?? '-'}，最低：${s.min_wpm ?? '-'}`;

      // list
      const list = Array.isArray(data.list)? data.list : [];
      if (!list.length){
        listBody.innerHTML='<tr><td colspan="9">尚無資料</td></tr>';
      } else {
        listBody.innerHTML = list.map(r=>`
          <tr>
            <td>${r.started_at}</td>
            <td>${r.ended_at}</td>
            <td>${r.mode==='timed'?'限時':'計時'}</td>
            <td>${r.grade}</td>
            <td>${r.target_quota}</td>
            <td>${r.correct_chars}</td>
            <td>${r.wrong_chars}</td>
            <td>${r.wpm}</td>
            <td>${r.end_reason==='button'?'手動':'自動'}</td>
          </tr>
        `).join('');
      }

      // chart
      const series = Array.isArray(data.series)? data.series : [];
      const labels = series.map(p=>fmt(p.ts * 1000));
      const values = series.map(p=>p.wpm);
      if (chart) chart.destroy();
      chart = new Chart(ctx, {
        type: 'line',
        data: { labels, datasets:[{ label:'WPM', data: values, tension:0.25 }] },
        options: {
          responsive: true,
          scales: { y: { beginAtZero: true } },
          plugins: { legend: { display: true } }
        }
      });

      inlineStatus.textContent = `最後更新時間：${fmt(Date.now())}`;

    }catch(e){
      msg.textContent = e.message;
      msg.className = 'msg error';
      listBody.innerHTML='<tr><td colspan="9">載入失敗</td></tr>';
    }
  }

  btn.addEventListener('click', query);
  // 預設查近 30 天
  const d = new Date(); const p = n=>String(n).padStart(2,'0');
  const toDate = (dd)=>`${dd.getFullYear()}-${p(dd.getMonth()+1)}-${p(dd.getDate())}`;
  end.value = toDate(d);
  const d2 = new Date(d.getTime()-29*86400000);
  start.value = toDate(d2);

  query();
})();

