/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: typing_gemini
-- ------------------------------------------------------
-- Server version	10.11.11-MariaDB-0+deb12u1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `start_time` timestamp NOT NULL,
  `end_time` timestamp NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `announcements_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `classes`
--

DROP TABLE IF EXISTS `classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `classes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(100) NOT NULL COMMENT '班級名稱 (例如: C101)',
  `grade_level` int(11) DEFAULT NULL COMMENT '所屬年級',
  PRIMARY KEY (`id`),
  UNIQUE KEY `class_name` (`class_name`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='班級管理表 (管理者維護)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `classes`
--

LOCK TABLES `classes` WRITE;
/*!40000 ALTER TABLE `classes` DISABLE KEYS */;
INSERT INTO `classes` VALUES
(1,'301',3),
(2,'302',3),
(3,'303',3),
(4,'304',3),
(5,'305',3),
(6,'306',3),
(7,'401',4),
(8,'402',4),
(9,'403',4),
(10,'404',4),
(11,'405',4),
(12,'406',4),
(13,'501',5),
(14,'502',5),
(15,'503',5),
(16,'504',5),
(17,'505',5);
/*!40000 ALTER TABLE `classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `competition_registrations`
--

DROP TABLE IF EXISTS `competition_registrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `competition_registrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `competition_id` int(11) NOT NULL,
  `registered_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `competition_id` (`competition_id`),
  CONSTRAINT `competition_registrations_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `users` (`id`),
  CONSTRAINT `competition_registrations_ibfk_2` FOREIGN KEY (`competition_id`) REFERENCES `competitions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `competition_registrations`
--

LOCK TABLES `competition_registrations` WRITE;
/*!40000 ALTER TABLE `competition_registrations` DISABLE KEYS */;
/*!40000 ALTER TABLE `competition_registrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `competition_scores`
--

DROP TABLE IF EXISTS `competition_scores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `competition_scores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `competition_id` int(11) NOT NULL,
  `time_taken_seconds` int(11) NOT NULL,
  `chars_completed` int(11) NOT NULL,
  `errors` int(11) NOT NULL,
  `wpm` decimal(5,1) NOT NULL,
  `submitted_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `competition_id` (`competition_id`),
  CONSTRAINT `competition_scores_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `users` (`id`),
  CONSTRAINT `competition_scores_ibfk_2` FOREIGN KEY (`competition_id`) REFERENCES `competitions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `competition_scores`
--

LOCK TABLES `competition_scores` WRITE;
/*!40000 ALTER TABLE `competition_scores` DISABLE KEYS */;
/*!40000 ALTER TABLE `competition_scores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `competitions`
--

DROP TABLE IF EXISTS `competitions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `competitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `organizer_id` int(11) NOT NULL,
  `details` text DEFAULT NULL,
  `reg_start_time` timestamp NOT NULL,
  `reg_end_time` timestamp NOT NULL,
  `event_time` timestamp NOT NULL,
  `eligibility_rules` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`eligibility_rules`)),
  `mode_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`mode_settings`)),
  PRIMARY KEY (`id`),
  KEY `organizer_id` (`organizer_id`),
  CONSTRAINT `competitions_ibfk_1` FOREIGN KEY (`organizer_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `competitions`
--

LOCK TABLES `competitions` WRITE;
/*!40000 ALTER TABLE `competitions` DISABLE KEYS */;
/*!40000 ALTER TABLE `competitions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_items`
--

DROP TABLE IF EXISTS `event_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL DEFAULT 1,
  `eligibility` varchar(16) NOT NULL DEFAULT 'all',
  `mode` enum('measured','timed') NOT NULL,
  `char_quota` int(11) DEFAULT NULL,
  `time_limit_seconds` int(11) DEFAULT NULL,
  `question_source` enum('random','fixed') NOT NULL DEFAULT 'random',
  `grade_scope` varchar(16) NOT NULL DEFAULT 'all',
  `fixed_bank_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`fixed_bank_ids`)),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_event_items_event` (`event_id`),
  KEY `idx_event_items_order` (`event_id`,`item_order`),
  CONSTRAINT `fk_event_items_event` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_items`
--

LOCK TABLES `event_items` WRITE;
/*!40000 ALTER TABLE `event_items` DISABLE KEYS */;
INSERT INTO `event_items` VALUES
(1,3,1,'3,4','measured',500,NULL,'random','3,4',NULL,'2025-11-03 06:17:16'),
(2,3,2,'5,6','measured',1000,NULL,'random','5,6',NULL,'2025-11-03 06:17:16'),
(3,4,1,'all','measured',500,NULL,'random','all',NULL,'2025-11-03 07:58:01'),
(4,5,1,'all','measured',500,NULL,'random','all',NULL,'2025-11-17 05:17:47');
/*!40000 ALTER TABLE `event_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_participants`
--

DROP TABLE IF EXISTS `event_participants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_participants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) NOT NULL COMMENT '活動 ID',
  `student_id` int(11) NOT NULL COMMENT '學生 ID',
  `registered_at` timestamp NULL DEFAULT current_timestamp() COMMENT '報名/加入時間',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_event_student` (`event_id`,`student_id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `event_participants_ibfk_1` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE,
  CONSTRAINT `event_participants_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活動參與者(報名)表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_participants`
--

LOCK TABLES `event_participants` WRITE;
/*!40000 ALTER TABLE `event_participants` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_participants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_submissions`
--

DROP TABLE IF EXISTS `event_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_submissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) NOT NULL COMMENT '活動 ID',
  `student_id` int(11) NOT NULL COMMENT '學生 ID',
  `time_taken_seconds` int(11) NOT NULL COMMENT '耗時多少秒',
  `chars_completed` int(11) NOT NULL COMMENT '完成字數 (依規則計算)',
  `errors` int(11) NOT NULL COMMENT '錯幾個字',
  `wpm` decimal(5,1) NOT NULL COMMENT '每分鐘正確字數',
  `submitted_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `event_id` (`event_id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `event_submissions_ibfk_1` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE,
  CONSTRAINT `event_submissions_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活動(測驗/比賽)成績表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_submissions`
--

LOCK TABLES `event_submissions` WRITE;
/*!40000 ALTER TABLE `event_submissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_submissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `events`
--

DROP TABLE IF EXISTS `events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_type` enum('test','competition') NOT NULL COMMENT '活動類型 (測驗或比賽)',
  `title` varchar(255) NOT NULL COMMENT '活動名稱',
  `owner_id` int(11) NOT NULL COMMENT '建立者 (管理者或教師)',
  `start_time` timestamp NOT NULL COMMENT '活動開始時間',
  `end_time` timestamp NOT NULL COMMENT '活動結束時間',
  `reg_start_time` timestamp NULL DEFAULT NULL COMMENT '報名開始時間',
  `reg_end_time` timestamp NULL DEFAULT NULL COMMENT '報名結束時間',
  `details` text DEFAULT NULL COMMENT '其他注意事項 (對應 "活動辦法")',
  `eligibility` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '參與資格' CHECK (json_valid(`eligibility`)),
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '型式與題目設定' CHECK (json_valid(`settings`)),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `owner_id` (`owner_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='合併的活動(測驗/比賽)設定表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `events`
--

LOCK TABLES `events` WRITE;
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
INSERT INTO `events` VALUES
(1,'test','3年級期中測驗',1,'2025-11-03 00:00:00','2025-11-03 08:01:00',NULL,NULL,NULL,'{\"type\":\"grade\",\"grades\":[\"3\"],\"class_ids\":[]}','{\"mode\":\"measured\",\"duration\":\"60\",\"char_count\":\"500\",\"question_source\":\"random\",\"random_grades\":[\"3\"],\"specific_content\":null}','2025-10-31 05:48:46'),
(2,'competition','鍵客盃',1,'2025-11-05 05:30:00','2025-11-05 08:00:00','2025-10-31 00:00:00','2025-11-04 08:00:00','1. 比賽分為 3、4、5、6 年級，共 4 級。','{\"type\":\"all\",\"grades\":[],\"class_ids\":[]}','{\"mode\":\"measured\",\"duration\":\"60\",\"char_count\":\"500\",\"question_source\":\"random\",\"random_grades\":[\"3\",\"4\",\"5\",\"6\"],\"specific_content\":null}','2025-10-31 05:51:32'),
(3,'competition','2025鍵客盃',1,'2025-11-06 00:00:00','2025-11-06 07:00:00','2025-11-03 00:00:00','2025-11-04 08:00:00',NULL,NULL,'{}','2025-11-03 06:17:16'),
(4,'test','Test',8,'2025-11-03 08:00:00','2025-11-04 04:00:00',NULL,NULL,'DDD',NULL,'{}','2025-11-03 07:58:01'),
(5,'test','就是要打字',8,'2025-11-18 04:00:00','2025-11-18 04:30:00',NULL,NULL,NULL,NULL,'{}','2025-11-17 05:17:47');
/*!40000 ALTER TABLE `events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `login_tokens`
--

DROP TABLE IF EXISTS `login_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `login_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `token` char(5) NOT NULL,
  `expires_at` timestamp NOT NULL,
  `is_used` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `login_tokens_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `login_tokens`
--

LOCK TABLES `login_tokens` WRITE;
/*!40000 ALTER TABLE `login_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `login_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operation_logs`
--

DROP TABLE IF EXISTS `operation_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `operation_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `username` varchar(100) DEFAULT NULL,
  `action` varchar(255) NOT NULL,
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`details`)),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=438 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operation_logs`
--

LOCK TABLES `operation_logs` WRITE;
/*!40000 ALTER TABLE `operation_logs` DISABLE KEYS */;
INSERT INTO `operation_logs` VALUES
(1,1,'typing','USER_LOGIN',NULL,'2025-10-26 11:30:56'),
(2,1,'typing','CLASS_CREATE','{\"id\":\"3\",\"name\":\"301\"}','2025-10-26 11:31:21'),
(3,1,'typing','CLASS_CREATE','{\"id\":\"4\",\"name\":\"401\"}','2025-10-26 11:31:46'),
(4,1,'typing','CLASS_CREATE','{\"id\":\"5\",\"name\":\"501\"}','2025-10-26 11:32:01'),
(5,1,'typing','CLASS_CREATE','{\"id\":\"6\",\"name\":\"601\"}','2025-10-26 11:33:42'),
(6,1,'typing','USER_UPDATE','{\"id\":\"2\",\"username\":\"teacher\"}','2025-10-26 11:34:05'),
(7,1,'typing','USER_LOGOUT',NULL,'2025-10-26 11:42:40'),
(8,1,'typing','USER_LOGIN',NULL,'2025-10-26 11:42:50'),
(9,1,'typing','USER_LOGOUT',NULL,'2025-10-26 11:59:31'),
(10,1,'typing','USER_LOGIN',NULL,'2025-10-26 11:59:44'),
(11,1,'typing','CLASS_CREATE','{\"id\":\"7\",\"name\":\"302\"}','2025-10-26 12:00:22'),
(12,1,'typing','USER_LOGOUT',NULL,'2025-10-26 12:06:02'),
(13,1,'typing','USER_LOGIN',NULL,'2025-10-26 12:06:13'),
(14,1,'typing','USER_CREATE','{\"id\":\"4\",\"username\":\"weiwei\"}','2025-10-26 12:06:29'),
(15,1,'typing','USER_LOGIN',NULL,'2025-10-26 12:48:44'),
(16,1,'typing','EXPORT_USERS',NULL,'2025-10-26 12:48:57'),
(17,1,'typing','USER_CREATE','{\"id\":\"5\",\"username\":\"dodo\"}','2025-10-26 12:51:07'),
(18,1,'typing','CLASS_CREATE','{\"id\":\"8\",\"name\":\"303\"}','2025-10-26 12:51:34'),
(19,1,'typing','CLASS_DELETE','{\"id\":\"8\"}','2025-10-26 12:52:21'),
(20,1,'typing','CLASS_DELETE','{\"id\":\"7\"}','2025-10-26 12:52:25'),
(21,1,'typing','USER_UPDATE','{\"id\":\"5\",\"username\":\"dodo\"}','2025-10-26 12:57:45'),
(22,1,'typing','CLASS_DELETE','{\"id\":\"6\"}','2025-10-26 12:57:55'),
(23,1,'typing','USER_LOGOUT',NULL,'2025-10-26 13:04:35'),
(24,1,'typing','USER_LOGIN',NULL,'2025-10-26 13:04:46'),
(25,1,'typing','USER_UPDATE','{\"id\":\"5\",\"username\":\"dodo\"}','2025-10-26 13:05:12'),
(26,1,'typing','CLASS_DELETE','{\"id\":\"1\"}','2025-10-26 13:05:25'),
(27,1,'typing','USER_LOGOUT',NULL,'2025-10-26 13:30:31'),
(28,1,'typing','USER_LOGIN',NULL,'2025-10-26 13:30:41'),
(29,1,'typing','USER_LOGOUT',NULL,'2025-10-26 13:32:11'),
(30,1,'typing','USER_LOGIN',NULL,'2025-10-26 13:32:24'),
(31,1,'typing','CLASS_CREATE','{\"id\":\"9\",\"name\":\"AAA\"}','2025-10-26 13:32:36'),
(32,1,'typing','USER_UPDATE','{\"id\":\"5\",\"username\":\"dodo\"}','2025-10-26 13:32:51'),
(33,1,'typing','USER_UPDATE','{\"id\":\"3\",\"username\":\"student\"}','2025-10-26 13:33:57'),
(34,1,'typing','CLASS_DELETE','{\"id\":\"9\"}','2025-10-26 13:34:11'),
(35,1,'typing','USER_LOGOUT',NULL,'2025-10-26 13:34:38'),
(36,1,'typing','USER_LOGIN',NULL,'2025-10-26 13:34:48'),
(37,1,'typing','CLASS_CREATE','{\"id\":\"10\",\"name\":\"BBB\"}','2025-10-26 13:50:03'),
(38,1,'typing','CLASS_DELETE','{\"id\":\"10\"}','2025-10-26 13:50:07'),
(39,1,'typing','USER_UPDATE','{\"id\":\"3\",\"username\":\"student\"}','2025-10-26 13:50:28'),
(40,1,'typing','USER_UPDATE','{\"id\":\"5\",\"username\":\"dodo\"}','2025-10-26 13:50:49'),
(41,1,'typing','CLASS_DELETE','{\"id\":\"2\"}','2025-10-26 13:51:02'),
(42,1,'typing','USER_LOGOUT',NULL,'2025-10-26 13:58:13'),
(43,1,'typing','USER_LOGIN',NULL,'2025-10-26 13:58:29'),
(44,1,'typing','USER_UPDATE','{\"id\":\"2\",\"username\":\"teacher\"}','2025-10-26 13:59:40'),
(45,1,'typing','USER_LOGOUT',NULL,'2025-10-26 14:00:46'),
(46,1,'typing','USER_LOGIN',NULL,'2025-10-27 01:33:32'),
(47,1,'typing','QUESTION_CREATE_SUCCESS','{\"content_preview\":\"\\u767d\\u65e5\\u4f9d\\u5c71\\u76e1\\uff0c\\u9ec3\\u6cb3\\u5165\\u6d77\\u6d41\\u3002\\n\\u6b32\\u7aae\\u5343\\u91cc\\u76ee\\uff0c\\u66f4\\u4e0a\\u4e00\\u5c64\\u6a13\\u3002\",\"level\":5,\"id\":\"1\"}','2025-10-27 01:35:25'),
(48,1,'typing','USER_LOGOUT',NULL,'2025-10-27 01:58:17'),
(49,1,'typing','USER_LOGIN',NULL,'2025-10-27 01:58:34'),
(50,1,'typing','USER_LOGOUT',NULL,'2025-10-27 02:07:38'),
(51,1,'typing','USER_LOGIN',NULL,'2025-10-27 02:07:50'),
(52,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"1\",\"name\":\"\\u767b\\u9e1b\\u96c0\\u6a13\",\"type\":\"\\u53e4\\u8a69\\u8a5e\\u8ce6\",\"level\":5,\"length\":25}','2025-10-27 02:08:19'),
(53,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u5c07\\u9032\\u9152\",\"type\":\"\\u53e4\\u8a69\\u8a5e\\u8ce6\",\"level\":5,\"length\":217,\"id\":\"2\"}','2025-10-27 02:10:15'),
(54,1,'typing','USER_LOGIN',NULL,'2025-10-27 03:20:50'),
(55,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"1\",\"name\":\"\\u6587\\u7ae0\"}','2025-10-27 03:22:24'),
(56,1,'typing','USER_LOGOUT',NULL,'2025-10-27 03:35:24'),
(57,1,'typing','USER_LOGIN',NULL,'2025-10-27 03:35:36'),
(58,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u9a0e\\u55ae\\u8eca\\uff5e\\u53f0\\u5317\\u2027\\u7a3b\\u9999\\u6c34\\u5cb8\",\"type\":\"\\u6587\\u7ae0\",\"level\":4,\"length\":185,\"id\":\"3\"}','2025-10-27 03:42:06'),
(59,1,'typing','USER_LOGIN',NULL,'2025-10-27 04:09:52'),
(60,1,'typing','USER_LOGOUT',NULL,'2025-10-27 04:10:36'),
(61,1,'typing','USER_LOGIN',NULL,'2025-10-27 04:10:43'),
(62,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"3\",\"name\":\"\\u9a0e\\u55ae\\u8eca\\uff5e\\u53f0\\u5317\\u2027\\u7a3b\\u9999\\u6c34\\u5cb8\",\"type_id\":1,\"level\":4,\"length\":185}','2025-10-27 04:41:56'),
(63,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"2\",\"name\":\"\\u5c07\\u9032\\u9152\",\"type_id\":2,\"level\":5,\"length\":217}','2025-10-27 04:42:05'),
(64,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"1\",\"name\":\"\\u767b\\u9e1b\\u96c0\\u6a13\",\"type_id\":2,\"level\":5,\"length\":25}','2025-10-27 04:42:14'),
(65,1,'typing','QTYPE_CREATE_SUCCESS','{\"id\":\"5\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 04:42:42'),
(66,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u5831\\u5c0e\"}','2025-10-27 04:43:20'),
(67,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u8209\\u982d\\u4e09\\u5c3a\",\"type_id\":4,\"level\":4,\"length\":7,\"id\":\"4\"}','2025-10-27 04:44:45'),
(68,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u540d\\u8a00\"}','2025-10-27 04:45:04'),
(69,1,'typing','USER_LOGIN',NULL,'2025-10-27 05:18:30'),
(70,1,'typing','USER_LOGIN',NULL,'2025-10-27 05:24:44'),
(71,1,'typing','USER_LOGOUT',NULL,'2025-10-27 05:49:15'),
(72,1,'typing','USER_LOGIN',NULL,'2025-10-27 05:49:25'),
(73,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u5929\\u516c\",\"type_id\":5,\"level\":4,\"length\":5,\"id\":\"5\"}','2025-10-27 05:50:30'),
(74,1,'typing','QTYPE_DELETE_FAIL','{\"id\":\"5\",\"name\":\"\\u4fda\\u8a9e\",\"error\":\"Type in use\"}','2025-10-27 05:50:44'),
(75,1,'typing','QTYPE_DELETE_SUCCESS','{\"id\":\"5\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 05:50:44'),
(76,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"5\",\"name\":\"\\u5f65\\u8a9e\"}','2025-10-27 05:51:08'),
(77,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"5\",\"name\":\"\\u5929\\u516c\",\"type_id\":4,\"level\":4,\"length\":5}','2025-10-27 05:51:44'),
(78,1,'typing','QTYPE_CREATE_SUCCESS','{\"id\":\"6\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 05:52:18'),
(79,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"6\",\"name\":\"\\u4fd7\\u8a9e\"}','2025-10-27 05:52:39'),
(80,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"5\",\"name\":\"\\u5929\\u516c\",\"type_id\":6,\"level\":4,\"length\":5}','2025-10-27 05:52:51'),
(81,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u8209\\u982d\\u4e09\\u5c3a\",\"type_id\":6,\"level\":4,\"length\":7}','2025-10-27 05:53:02'),
(82,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"6\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 05:53:21'),
(83,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u8209\\u982d\\u4e09\\u5c3a\",\"type_id\":6,\"level\":4,\"length\":7}','2025-10-27 05:53:46'),
(84,1,'typing','USER_UPDATE','{\"id\":\"5\",\"username\":\"dodo\"}','2025-10-27 05:54:11'),
(85,1,'typing','USER_UPDATE','{\"id\":\"5\",\"username\":\"dodo\"}','2025-10-27 05:55:08'),
(86,1,'typing','USER_UPDATE','{\"id\":\"3\",\"username\":\"student\"}','2025-10-27 05:58:44'),
(87,1,'typing','CLASS_UPDATE','{\"id\":\"5\",\"name\":\"502\"}','2025-10-27 06:00:04'),
(88,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u8209\\u982d\\u4e09\\u5c3a\",\"type_id\":4,\"level\":4,\"length\":7}','2025-10-27 06:02:08'),
(89,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"5\",\"name\":\"\\u5929\\u516c\",\"type_id\":4,\"level\":4,\"length\":5}','2025-10-27 06:02:15'),
(90,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"6\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 06:02:45'),
(91,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u540d\\u8a00\"}','2025-10-27 06:02:48'),
(92,1,'typing','QTYPE_DELETE_SUCCESS','{\"id\":\"6\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 06:04:25'),
(93,1,'typing','QTYPE_DELETE_FAIL','{\"id\":\"4\",\"name\":\"\\u540d\\u8a00\",\"error\":\"Type in use\"}','2025-10-27 06:04:40'),
(94,1,'typing','QTYPE_DELETE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u540d\\u8a00\"}','2025-10-27 06:04:40'),
(95,1,'typing','USER_LOGIN',NULL,'2025-10-27 06:24:26'),
(96,1,'typing','CLASS_UPDATE','{\"id\":\"5\",\"name\":\"501\"}','2025-10-27 06:24:36'),
(97,1,'typing','CLASS_UPDATE','{\"id\":\"5\",\"name\":\"502\"}','2025-10-27 06:24:42'),
(98,1,'typing','CLASS_CREATE','{\"id\":\"11\",\"name\":\"302\"}','2025-10-27 06:24:52'),
(99,1,'typing','USER_LOGIN',NULL,'2025-10-27 07:17:29'),
(100,1,'typing','CLASS_DELETE','{\"id\":\"11\"}','2025-10-27 07:22:08'),
(101,1,'typing','CLASS_UPDATE','{\"id\":\"5\",\"name\":\"501\"}','2025-10-27 07:22:18'),
(102,1,'typing','USER_DELETE','{\"id\":\"5\",\"username\":\"dodo\"}','2025-10-27 07:22:39'),
(103,1,'typing','USER_UPDATE','{\"id\":\"2\",\"username\":\"teacher\"}','2025-10-27 07:23:05'),
(104,1,'typing','USER_CREATE','{\"id\":\"6\",\"username\":\"charles\"}','2025-10-27 07:23:57'),
(105,1,'typing','USER_UPDATE','{\"id\":\"4\",\"username\":\"weiwei\"}','2025-10-27 07:24:27'),
(106,1,'typing','USER_UPDATE','{\"id\":\"6\",\"username\":\"charles\"}','2025-10-27 07:24:36'),
(107,1,'typing','QTYPE_CREATE_SUCCESS','{\"id\":\"7\",\"name\":\"\\u91d1\\u53e5\\u540d\\u8a00\"}','2025-10-27 07:25:05'),
(108,1,'typing','QTYPE_CREATE_SUCCESS','{\"id\":\"8\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 07:25:25'),
(109,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"7\",\"name\":\"\\u540d\\u8a00\"}','2025-10-27 07:25:34'),
(110,1,'typing','QTYPE_UPDATE_SUCCESS','{\"id\":\"3\",\"name\":\"\\u73fe\\u4ee3\\u8a69\\u8a5e\"}','2025-10-27 07:25:46'),
(111,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"5\",\"name\":\"\\u5929\\u516c\",\"type_id\":8,\"level\":4,\"length\":5}','2025-10-27 07:25:58'),
(112,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u8209\\u982d\\u4e09\\u5c3a\",\"type_id\":8,\"level\":4,\"length\":7}','2025-10-27 07:26:09'),
(113,1,'typing','QTYPE_DELETE_FAIL','{\"id\":\"8\",\"name\":\"\\u4fda\\u8a9e\",\"error\":\"Type in use\"}','2025-10-27 07:26:21'),
(114,1,'typing','QTYPE_DELETE_SUCCESS','{\"id\":\"8\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 07:26:21'),
(115,1,'typing','USER_LOGIN',NULL,'2025-10-27 08:12:27'),
(116,1,'typing','QTYPE_CREATE_SUCCESS','{\"id\":\"9\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 08:12:51'),
(117,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u8209\\u982d\\u4e09\\u5c3a\",\"type_id\":9,\"level\":4,\"length\":7}','2025-10-27 08:13:00'),
(118,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"5\",\"name\":\"\\u5929\\u516c\",\"type_id\":9,\"level\":4,\"length\":5}','2025-10-27 08:13:06'),
(119,1,'typing','QTYPE_DELETE_FAIL','{\"id\":\"9\",\"name\":\"\\u4fda\\u8a9e\",\"error\":\"Type in use\"}','2025-10-27 08:13:14'),
(120,1,'typing','QTYPE_DELETE_SUCCESS','{\"id\":\"9\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 08:13:14'),
(121,1,'typing','QTYPE_CREATE_SUCCESS','{\"id\":\"10\",\"name\":\"\\u4fda\\u8a9e\"}','2025-10-27 08:20:27'),
(122,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"5\",\"name\":\"\\u5929\\u516c\",\"type_id\":10,\"level\":4,\"length\":5}','2025-10-27 08:20:36'),
(123,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"4\",\"name\":\"\\u8209\\u982d\\u4e09\\u5c3a\",\"type_id\":10,\"level\":4,\"length\":7}','2025-10-27 08:20:42'),
(124,1,'typing','QTYPE_DELETE_FAIL','{\"id\":\"10\",\"name\":\"\\u4fda\\u8a9e\",\"error\":\"Type in use\"}','2025-10-27 08:20:48'),
(125,1,'typing','USER_LOGIN',NULL,'2025-10-27 22:09:20'),
(126,1,'typing','USER_LOGIN',NULL,'2025-10-28 01:14:46'),
(127,1,'typing','USER_LOGIN',NULL,'2025-10-28 04:39:12'),
(128,1,'typing','EXPORT_USERS',NULL,'2025-10-28 04:43:27'),
(129,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u5fc3\\u7684\\u6084\\u6084\\u8a71\",\"type_id\":1,\"level\":3,\"length\":102,\"id\":\"6\"}','2025-10-28 04:53:44'),
(130,1,'typing','USER_LOGIN',NULL,'2025-10-28 10:50:35'),
(131,1,'typing','CLASS_CREATE','{\"id\":\"12\",\"name\":\"601\"}','2025-10-28 10:59:32'),
(132,1,'typing','USER_CREATE','{\"id\":\"7\",\"username\":\"rfes0000001\"}','2025-10-28 11:00:21'),
(133,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u4f60\\u597d\\uff0c\\u65b0\\u670b\\u53cb\",\"type_id\":1,\"level\":3,\"length\":267,\"id\":\"7\"}','2025-10-28 11:01:43'),
(134,1,'typing','QTYPE_CREATE_SUCCESS','{\"id\":\"11\",\"name\":\"\\u8ab2\\u6587\"}','2025-10-28 11:02:05'),
(135,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"7\",\"name\":\"\\u4f60\\u597d\\uff0c\\u65b0\\u670b\\u53cb\",\"type_id\":11,\"level\":3,\"length\":267}','2025-10-28 11:02:14'),
(136,1,'typing','QUESTION_UPDATE_SUCCESS','{\"id\":\"6\",\"name\":\"\\u5fc3\\u7684\\u6084\\u6084\\u8a71\",\"type_id\":11,\"level\":3,\"length\":102}','2025-10-28 11:02:24'),
(137,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u6211\\u5011\\u7684\\u7d04\\u5b9a\",\"type_id\":11,\"level\":3,\"length\":301,\"id\":\"8\"}','2025-10-28 11:03:59'),
(138,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u4e0b\\u8ab2\\u5341\\u5206\\u9418\",\"type_id\":11,\"level\":3,\"length\":316,\"id\":\"9\"}','2025-10-28 11:05:35'),
(139,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u7559\\u4f4f\\u4eca\\u5929\\u7684\\u592a\\u967d\",\"type_id\":11,\"level\":3,\"length\":437,\"id\":\"10\"}','2025-10-28 11:07:39'),
(140,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u706b\\u5927\\u4e86\",\"type_id\":11,\"level\":3,\"length\":415,\"id\":\"11\"}','2025-10-28 11:09:56'),
(141,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u5728\\u5929\\u6674\\u4e86\\u7684\\u6642\\u5019\",\"type_id\":11,\"level\":6,\"length\":221,\"id\":\"12\"}','2025-10-28 11:11:14'),
(142,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u73cd\\u73e0\\u9ce5\",\"type_id\":11,\"level\":6,\"length\":1055,\"id\":\"13\"}','2025-10-28 11:14:25'),
(143,1,'typing','QUESTION_CREATE_SUCCESS','{\"name\":\"\\u5ba2\\u81f3\",\"type_id\":2,\"level\":6,\"length\":67,\"id\":\"14\"}','2025-10-28 11:15:24'),
(144,1,'typing','USER_LOGIN',NULL,'2025-10-28 11:43:00'),
(145,1,'typing','USER_LOGIN',NULL,'2025-10-28 12:15:21'),
(146,1,'typing','CLASS_CREATE','{\"id\":\"13\",\"name\":\"302\"}','2025-10-28 12:18:22'),
(147,1,'typing','USER_UPDATE','{\"id\":\"2\",\"username\":\"teacher\"}','2025-10-28 12:18:36'),
(148,1,'typing','USER_LOGIN',NULL,'2025-10-28 12:51:34'),
(149,1,'typing','USER_LOGIN',NULL,'2025-10-28 12:52:17'),
(150,1,'typing','USER_LOGOUT',NULL,'2025-10-28 13:34:12'),
(151,1,'typing','USER_LOGIN',NULL,'2025-10-28 13:34:23'),
(152,1,'typing','USER_LOGIN',NULL,'2025-10-28 14:19:55'),
(153,1,'typing','USER_LOGIN',NULL,'2025-10-28 14:42:08'),
(154,1,'typing','USER_LOGOUT',NULL,'2025-10-28 14:47:40'),
(155,1,'typing','USER_LOGIN',NULL,'2025-10-28 14:47:53'),
(156,NULL,NULL,'USER_LOGIN',NULL,'2025-10-29 11:15:24'),
(157,NULL,NULL,'USER_LOGIN',NULL,'2025-10-29 11:15:27'),
(158,1,'typing','USER_LOGIN',NULL,'2025-10-29 12:13:08'),
(159,1,'typing','USER_LOGIN',NULL,'2025-10-29 13:04:35'),
(160,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS\",\"requested_level\":3,\"calculated_level\":3,\"limit\":10}','2025-10-29 13:04:41'),
(161,1,'typing','GET_QUESTIONS_QUERY','{\"level\":3,\"found\":6}','2025-10-29 13:04:41'),
(162,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS\",\"requested_level\":3,\"calculated_level\":3,\"limit\":10}','2025-10-29 13:06:47'),
(163,1,'typing','GET_QUESTIONS_QUERY','{\"level\":3,\"found\":6}','2025-10-29 13:06:47'),
(164,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-29 13:58:44'),
(165,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":12,\"total_chars\":301}','2025-10-29 13:58:44'),
(166,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":84}','2025-10-29 14:00:49'),
(167,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":27,\"total_chars\":267}','2025-10-29 14:00:49'),
(168,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-29 14:03:22'),
(169,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":316}','2025-10-29 14:03:22'),
(170,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-29 14:05:29'),
(171,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":38,\"total_chars\":568}','2025-10-29 14:05:29'),
(172,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-29 14:22:28'),
(173,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":12,\"total_chars\":301}','2025-10-29 14:22:28'),
(174,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-29 14:23:20'),
(175,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-10-29 14:23:20'),
(176,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-29 14:25:44'),
(177,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":22,\"total_chars\":539}','2025-10-29 14:25:44'),
(178,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":1050}','2025-10-29 14:33:43'),
(179,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":59,\"total_chars\":1107}','2025-10-29 14:33:43'),
(180,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-29 14:34:11'),
(181,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":33,\"total_chars\":840}','2025-10-29 14:34:11'),
(182,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":1050}','2025-10-29 14:34:40'),
(183,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":59,\"total_chars\":1107}','2025-10-29 14:34:40'),
(184,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-29 14:36:06'),
(185,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":16,\"total_chars\":415}','2025-10-29 14:36:06'),
(186,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-29 14:36:27'),
(187,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":39,\"total_chars\":568}','2025-10-29 14:36:27'),
(188,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-29 14:36:53'),
(189,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":22,\"total_chars\":517}','2025-10-29 14:36:53'),
(190,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-29 14:37:19'),
(191,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":40,\"total_chars\":855}','2025-10-29 14:37:19'),
(192,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-29 14:37:46'),
(193,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":12,\"total_chars\":301}','2025-10-29 14:37:46'),
(194,1,'typing','USER_LOGIN',NULL,'2025-10-30 01:19:32'),
(195,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 01:19:44'),
(196,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":49,\"total_chars\":784}','2025-10-30 01:19:44'),
(197,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 01:22:08'),
(198,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":23,\"total_chars\":539}','2025-10-30 01:22:08'),
(199,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 01:24:02'),
(200,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":45,\"total_chars\":670}','2025-10-30 01:24:02'),
(201,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 01:24:29'),
(202,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":44,\"total_chars\":704}','2025-10-30 01:24:29'),
(203,1,'typing','USER_LOGIN',NULL,'2025-10-30 01:26:14'),
(204,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 01:26:32'),
(205,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":29,\"total_chars\":617}','2025-10-30 01:26:32'),
(206,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":250}','2025-10-30 01:45:52'),
(207,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-10-30 01:45:52'),
(208,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 01:53:14'),
(209,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":23,\"total_chars\":539}','2025-10-30 01:53:14'),
(210,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":1050}','2025-10-30 01:53:31'),
(211,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":52,\"total_chars\":1156}','2025-10-30 01:53:31'),
(212,1,'typing','USER_LOGOUT',NULL,'2025-10-30 01:59:29'),
(213,1,'typing','USER_LOGIN',NULL,'2025-10-30 02:08:34'),
(214,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 02:08:49'),
(215,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":34,\"total_chars\":753}','2025-10-30 02:08:49'),
(216,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 02:15:07'),
(217,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":44,\"total_chars\":704}','2025-10-30 02:15:07'),
(218,1,'typing','USER_LOGIN',NULL,'2025-10-30 02:45:46'),
(219,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 02:49:17'),
(220,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":29,\"total_chars\":738}','2025-10-30 02:49:17'),
(221,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 03:12:56'),
(222,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-10-30 03:12:56'),
(223,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 03:14:47'),
(224,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":39,\"total_chars\":833}','2025-10-30 03:14:47'),
(225,1,'typing','USER_LOGIN',NULL,'2025-10-30 03:52:49'),
(226,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 03:53:12'),
(227,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":44,\"total_chars\":583}','2025-10-30 03:53:12'),
(228,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 04:04:00'),
(229,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":34,\"total_chars\":753}','2025-10-30 04:04:00'),
(230,1,'typing','USER_LOGIN',NULL,'2025-10-30 08:00:14'),
(231,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 08:00:44'),
(232,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":6,\"total_chars\":102}','2025-10-30 08:00:44'),
(233,1,'typing','USER_LOGIN',NULL,'2025-10-30 11:05:51'),
(234,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 11:06:06'),
(235,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":27,\"total_chars\":267}','2025-10-30 11:06:06'),
(236,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 11:09:33'),
(237,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":6,\"total_chars\":102}','2025-10-30 11:09:33'),
(238,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 11:12:00'),
(239,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":29,\"total_chars\":738}','2025-10-30 11:12:00'),
(240,1,'typing','USER_LOGIN',NULL,'2025-10-30 11:25:40'),
(241,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 11:31:42'),
(242,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-10-30 11:31:42'),
(243,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 11:34:46'),
(244,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":23,\"total_chars\":539}','2025-10-30 11:34:46'),
(245,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 12:04:09'),
(246,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":39,\"total_chars\":833}','2025-10-30 12:04:09'),
(247,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 12:09:43'),
(248,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":27,\"total_chars\":267}','2025-10-30 12:09:43'),
(249,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 12:13:03'),
(250,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":12,\"total_chars\":301}','2025-10-30 12:13:03'),
(251,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 12:15:16'),
(252,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":33,\"total_chars\":731}','2025-10-30 12:15:16'),
(253,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 12:18:36'),
(254,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-10-30 12:18:36'),
(255,1,'typing','USER_LOGIN',NULL,'2025-10-30 13:21:05'),
(256,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 13:21:43'),
(257,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":27,\"total_chars\":267}','2025-10-30 13:21:43'),
(258,1,'typing','USER_LOGIN',NULL,'2025-10-30 13:44:30'),
(259,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 13:44:43'),
(260,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":16,\"total_chars\":415}','2025-10-30 13:44:43'),
(261,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-10-30 13:45:29'),
(262,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":16,\"total_chars\":415}','2025-10-30 13:45:29'),
(263,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 13:48:25'),
(264,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":50,\"total_chars\":806}','2025-10-30 13:48:25'),
(265,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 13:48:40'),
(266,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":23,\"total_chars\":539}','2025-10-30 13:48:40'),
(267,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-10-30 13:48:58'),
(268,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":44,\"total_chars\":583}','2025-10-30 13:48:58'),
(269,1,'typing','USER_LOGIN',NULL,'2025-10-31 01:38:43'),
(270,1,'typing','EVENT_SETUP_DB_ERROR','{\"error\":\"SQLSTATE[42S22]: Column not found: 1054 Unknown column \'start_time\' in \'SELECT\'\"}','2025-10-31 01:38:48'),
(271,1,'typing','USER_LOGIN',NULL,'2025-10-31 02:11:47'),
(272,1,'typing','USER_UPDATE','{\"id\":\"7\",\"username\":\"rfes0000001\"}','2025-10-31 02:25:57'),
(273,1,'typing','USER_LOGIN',NULL,'2025-10-31 03:32:28'),
(274,1,'typing','USER_LOGIN',NULL,'2025-10-31 05:40:04'),
(275,1,'typing','TEST_CREATE','{\"id\":\"1\",\"title\":\"3\\u5e74\\u7d1a\\u671f\\u4e2d\\u6e2c\\u9a57\"}','2025-10-31 05:48:46'),
(276,1,'typing','COMPETITION_CREATE','{\"id\":\"2\",\"title\":\"\\u9375\\u5ba2\\u76c3\"}','2025-10-31 05:51:32'),
(277,1,'typing','EVENT_UPDATE_SUCCESS','{\"id\":\"2\",\"title\":\"\\u9375\\u5ba2\\u76c3\"}','2025-10-31 05:52:42'),
(278,1,'typing','USER_LOGIN',NULL,'2025-11-01 09:01:22'),
(279,1,'typing','USER_LOGIN',NULL,'2025-11-03 01:49:27'),
(280,1,'typing','USER_LOGIN',NULL,'2025-11-03 02:49:42'),
(281,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:09:04'),
(282,NULL,NULL,'USER_LOGIN',NULL,'2025-11-03 05:26:11'),
(283,NULL,NULL,'USER_LOGIN',NULL,'2025-11-03 05:26:13'),
(284,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:27:23'),
(285,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:27:31'),
(286,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:27:32'),
(287,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:27:41'),
(288,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:27:42'),
(289,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:27:46'),
(290,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:27:54'),
(291,1,'typing','USER_LOGOUT',NULL,'2025-11-03 05:28:04'),
(292,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:28:13'),
(293,1,'typing','USER_CREATE','{\"id\":\"8\",\"username\":\"judy0715\"}','2025-11-03 05:29:58'),
(294,1,'typing','USER_LOGOUT',NULL,'2025-11-03 05:30:05'),
(295,8,'judy0715','USER_LOGIN',NULL,'2025-11-03 05:30:19'),
(296,1,'typing','USER_LOGIN',NULL,'2025-11-03 05:31:43'),
(297,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-03 05:32:03'),
(298,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":27,\"total_chars\":267}','2025-11-03 05:32:03'),
(299,1,'typing','USER_LOGIN',NULL,'2025-11-03 06:15:43'),
(300,8,'judy0715','USER_LOGIN',NULL,'2025-11-03 06:17:43'),
(301,NULL,NULL,'GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-03 07:43:51'),
(302,NULL,NULL,'GET_QUESTIONS_SUCCESS','{\"lines_fetched\":12,\"total_chars\":301}','2025-11-03 07:43:51'),
(303,NULL,NULL,'GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-03 07:44:12'),
(304,NULL,NULL,'GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":316}','2025-11-03 07:44:12'),
(305,NULL,NULL,'GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-11-03 07:47:12'),
(306,NULL,NULL,'GET_QUESTIONS_SUCCESS','{\"lines_fetched\":28,\"total_chars\":716}','2025-11-03 07:47:12'),
(307,1,'typing','USER_LOGIN',NULL,'2025-11-03 07:54:41'),
(308,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-03 07:54:48'),
(309,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-11-03 07:54:48'),
(310,1,'typing','USER_LOGOUT',NULL,'2025-11-03 07:55:22'),
(311,8,'judy0715','USER_LOGIN',NULL,'2025-11-03 07:55:38'),
(312,8,'judy0715','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-03 07:55:48'),
(313,8,'judy0715','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":27,\"total_chars\":267}','2025-11-03 07:55:48'),
(314,1,'typing','USER_LOGIN',NULL,'2025-11-10 14:33:50'),
(315,1,'typing','CLASS_CREATE','{\"id\":\"1\",\"name\":\"301\"}','2025-11-10 14:34:09'),
(316,1,'typing','CLASS_CREATE','{\"id\":\"2\",\"name\":\"302\"}','2025-11-10 14:34:19'),
(317,1,'typing','CLASS_CREATE','{\"id\":\"3\",\"name\":\"303\"}','2025-11-10 14:34:28'),
(318,1,'typing','CLASS_CREATE','{\"id\":\"4\",\"name\":\"304\"}','2025-11-10 14:34:39'),
(319,1,'typing','CLASS_CREATE','{\"id\":\"5\",\"name\":\"305\"}','2025-11-10 14:34:49'),
(320,1,'typing','CLASS_CREATE','{\"id\":\"6\",\"name\":\"306\"}','2025-11-10 14:34:58'),
(321,1,'typing','CLASS_CREATE','{\"id\":\"7\",\"name\":\"401\"}','2025-11-10 14:35:07'),
(322,1,'typing','CLASS_CREATE','{\"id\":\"8\",\"name\":\"402\"}','2025-11-10 14:35:15'),
(323,1,'typing','CLASS_CREATE','{\"id\":\"9\",\"name\":\"403\"}','2025-11-10 14:35:27'),
(324,1,'typing','USER_DELETE','{\"id\":\"6\",\"username\":\"charles\"}','2025-11-10 14:39:50'),
(325,1,'typing','USER_DELETE','{\"id\":\"7\",\"username\":\"rfes0000001\"}','2025-11-10 14:40:24'),
(326,1,'typing','USER_UPDATE','{\"id\":\"8\",\"username\":\"judy0715\"}','2025-11-10 14:56:36'),
(327,1,'typing','USER_UPDATE','{\"id\":\"2\",\"username\":\"teacher\"}','2025-11-10 14:57:00'),
(328,8,'judy0715','USER_LOGIN',NULL,'2025-11-17 04:08:17'),
(329,NULL,NULL,'USER_LOGIN',NULL,'2025-11-17 04:43:18'),
(330,1,'typing','USER_LOGIN',NULL,'2025-11-17 04:43:27'),
(331,1,'typing','USER_LOGIN',NULL,'2025-11-17 04:43:41'),
(332,1,'typing','USER_CREATE','{\"id\":\"353\",\"username\":\"tony\"}','2025-11-17 04:44:06'),
(333,1,'typing','USER_LOGIN',NULL,'2025-11-17 04:49:11'),
(334,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-17 04:49:26'),
(335,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":316}','2025-11-17 04:49:26'),
(336,1,'typing','USER_CREATE','{\"id\":\"354\",\"username\":\"san\"}','2025-11-17 04:51:54'),
(337,1,'typing','USER_UPDATE','{\"id\":\"354\",\"username\":\"san\"}','2025-11-17 04:52:31'),
(338,1,'typing','USER_LOGOUT',NULL,'2025-11-17 04:53:00'),
(339,8,'judy0715','USER_LOGIN',NULL,'2025-11-17 05:14:55'),
(340,1,'typing','USER_LOGIN',NULL,'2025-11-17 05:17:33'),
(341,353,'tony','USER_LOGIN',NULL,'2025-11-17 08:05:10'),
(342,353,'tony','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-17 08:07:59'),
(343,353,'tony','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":316}','2025-11-17 08:07:59'),
(344,353,'tony','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-17 08:09:05'),
(345,353,'tony','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":316}','2025-11-17 08:09:05'),
(346,353,'tony','USER_LOGOUT',NULL,'2025-11-17 08:09:34'),
(347,NULL,NULL,'USER_LOGIN',NULL,'2025-11-17 08:40:01'),
(348,1,'typing','USER_LOGIN',NULL,'2025-11-19 11:54:34'),
(349,1,'typing','USER_LOGOUT',NULL,'2025-11-19 11:55:16'),
(350,1,'typing','USER_LOGIN',NULL,'2025-11-19 11:55:26'),
(351,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-19 11:55:33'),
(352,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-11-19 11:55:33'),
(353,1,'typing','USER_LOGIN',NULL,'2025-11-20 01:46:32'),
(354,1,'typing','USER_LOGIN',NULL,'2025-11-20 01:46:45'),
(355,1,'typing','USER_LOGIN',NULL,'2025-11-20 01:48:18'),
(356,1,'typing','USER_LOGIN',NULL,'2025-11-20 01:50:07'),
(357,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 01:50:13'),
(358,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":6,\"total_chars\":102}','2025-11-20 01:50:13'),
(359,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-11-20 01:53:19'),
(360,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":29,\"total_chars\":617}','2025-11-20 01:53:19'),
(361,1,'typing','USER_LOGIN',NULL,'2025-11-20 02:39:44'),
(362,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":4,\"requested_length\":100}','2025-11-20 02:47:40'),
(363,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":4,\"total_chars\":192}','2025-11-20 02:47:40'),
(364,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 02:49:52'),
(365,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":4,\"requested_length\":500}','2025-11-20 02:52:26'),
(366,1,'typing','GET_QUESTIONS_FALLBACK_START','{\"target\":500,\"found\":197}','2025-11-20 02:52:26'),
(367,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":39,\"total_chars\":719}','2025-11-20 02:52:26'),
(368,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 02:52:36'),
(369,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-11-20 02:53:17'),
(370,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":22,\"total_chars\":517}','2025-11-20 02:53:17'),
(371,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 02:53:28'),
(372,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":4,\"requested_length\":100}','2025-11-20 02:54:50'),
(373,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":3,\"total_chars\":185}','2025-11-20 02:54:50'),
(374,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 02:59:14'),
(375,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-11-20 02:59:18'),
(376,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":43,\"total_chars\":682}','2025-11-20 02:59:18'),
(377,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 02:59:28'),
(378,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":4,\"requested_length\":500}','2025-11-20 03:12:28'),
(379,1,'typing','GET_QUESTIONS_FALLBACK_START','{\"target\":500,\"found\":197}','2025-11-20 03:12:28'),
(380,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":30,\"total_chars\":715}','2025-11-20 03:12:28'),
(381,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 03:12:58'),
(382,1,'typing','USER_LOGIN',NULL,'2025-11-20 05:08:14'),
(383,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":4,\"requested_length\":100}','2025-11-20 05:08:27'),
(384,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":5,\"total_chars\":197}','2025-11-20 05:08:27'),
(385,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 05:09:58'),
(386,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":4,\"requested_length\":100}','2025-11-20 05:11:14'),
(387,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":5,\"total_chars\":197}','2025-11-20 05:11:14'),
(388,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 05:12:25'),
(389,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":4,\"requested_length\":100}','2025-11-20 05:12:31'),
(390,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":5,\"total_chars\":197}','2025-11-20 05:12:31'),
(391,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 05:21:29'),
(392,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":6,\"total_chars\":102}','2025-11-20 05:21:29'),
(393,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 05:23:06'),
(394,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 05:23:24'),
(395,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-11-20 05:23:24'),
(396,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 05:24:54'),
(397,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 05:30:38'),
(398,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":6,\"total_chars\":102}','2025-11-20 05:30:38'),
(399,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 05:30:40'),
(400,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":6,\"requested_length\":1050}','2025-11-20 05:30:51'),
(401,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":13,\"total_chars\":1055}','2025-11-20 05:30:51'),
(402,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 05:30:53'),
(403,1,'typing','USER_LOGIN',NULL,'2025-11-20 07:10:05'),
(404,1,'typing','USER_LOGOUT',NULL,'2025-11-20 07:25:38'),
(405,1,'typing','USER_LOGIN',NULL,'2025-11-20 07:25:44'),
(406,1,'typing','USER_LOGIN',NULL,'2025-11-20 09:14:13'),
(407,1,'typing','USER_LOGIN',NULL,'2025-11-20 10:14:32'),
(408,1,'typing','USER_LOGIN',NULL,'2025-11-20 11:49:34'),
(409,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 11:50:20'),
(410,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":12,\"total_chars\":301}','2025-11-20 11:50:20'),
(411,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 11:51:41'),
(412,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 11:55:13'),
(413,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":16,\"total_chars\":415}','2025-11-20 11:55:13'),
(414,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 11:55:19'),
(415,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 11:59:07'),
(416,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":316}','2025-11-20 11:59:07'),
(417,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 12:00:17'),
(418,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 12:03:40'),
(419,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":16,\"total_chars\":415}','2025-11-20 12:03:40'),
(420,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 12:04:30'),
(421,1,'typing','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 12:16:42'),
(422,1,'typing','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-11-20 12:16:42'),
(423,1,'typing','PRACTICE_LOG_CREATED',NULL,'2025-11-20 12:17:00'),
(424,1,'typing','USER_LOGOUT',NULL,'2025-11-20 12:23:59'),
(425,4,'weiwei','USER_LOGIN',NULL,'2025-11-20 12:24:08'),
(426,4,'weiwei','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 13:06:01'),
(427,4,'weiwei','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":316}','2025-11-20 13:06:01'),
(428,4,'weiwei','PRACTICE_LOG_CREATED',NULL,'2025-11-20 13:06:14'),
(429,4,'weiwei','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 13:41:39'),
(430,4,'weiwei','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":437}','2025-11-20 13:41:39'),
(431,4,'weiwei','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":100}','2025-11-20 13:45:00'),
(432,4,'weiwei','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":17,\"total_chars\":316}','2025-11-20 13:45:00'),
(433,4,'weiwei','PRACTICE_LOG_CREATED',NULL,'2025-11-20 13:45:21'),
(434,4,'weiwei','GET_QUESTIONS_START','{\"action\":\"FETCH_QUESTIONS_ONCE\",\"requested_level\":3,\"requested_length\":500}','2025-11-20 13:45:25'),
(435,4,'weiwei','GET_QUESTIONS_SUCCESS','{\"lines_fetched\":33,\"total_chars\":852}','2025-11-20 13:45:25'),
(436,4,'weiwei','PRACTICE_LOG_CREATED',NULL,'2025-11-20 13:45:36'),
(437,4,'weiwei','USER_LOGOUT',NULL,'2025-11-20 13:45:54');
/*!40000 ALTER TABLE `operation_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `question_types`
--

DROP TABLE IF EXISTS `question_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `question_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(50) NOT NULL COMMENT '類型名稱',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type_name` (`type_name`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='題庫題目類型表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `question_types`
--

LOCK TABLES `question_types` WRITE;
/*!40000 ALTER TABLE `question_types` DISABLE KEYS */;
INSERT INTO `question_types` VALUES
(10,'俚語'),
(2,'古詩詞賦'),
(7,'名言'),
(1,'文章'),
(3,'現代詩詞'),
(11,'課文');
/*!40000 ALTER TABLE `question_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test_bank`
--

DROP TABLE IF EXISTS `test_bank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test_bank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '題目名稱',
  `type_id` int(11) DEFAULT NULL COMMENT '題目類型 ID (FK to question_types)',
  `content` text NOT NULL,
  `length` int(11) NOT NULL DEFAULT 0 COMMENT '題目總字數(含標點)',
  `level` int(11) NOT NULL COMMENT '程度/適用年級 (3-6)',
  `includes_punctuation` tinyint(1) DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `update_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT '最後編修日期時間',
  PRIMARY KEY (`id`),
  KEY `idx_created_by` (`created_by`),
  KEY `fk_question_type` (`type_id`),
  CONSTRAINT `fk_question_type` FOREIGN KEY (`type_id`) REFERENCES `question_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `test_bank_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test_bank`
--

LOCK TABLES `test_bank` WRITE;
/*!40000 ALTER TABLE `test_bank` DISABLE KEYS */;
INSERT INTO `test_bank` VALUES
(1,'登鸛雀樓',2,'白日依山盡，黃河入海流。\n欲窮千里目，更上一層樓。',25,5,1,1,'2025-10-27 01:35:25','2025-10-27 04:42:14'),
(2,'將進酒',2,'君不見，黃河之水天上來，奔流到海不復回！\n君不見，高堂明鏡悲白髮，朝如青絲暮成雪！\n人生得意須盡歡，莫使金樽空對月。\n天生我材必有用，千金散盡還復來。\n烹羊宰牛且爲樂，會須一飲三百杯。\n岑夫子，丹丘生。將進酒君莫停。\n與君歌一曲，請君爲我傾耳聽。\n鐘鼓饌玉不足貴，但願長醉不用醒。\n古來聖賢皆寂寞，惟有飲者留其名。\n陳王昔時宴平樂，斗酒十千恣歡謔。\n主人何為言少錢？徑須沽取對君酌。\n五花馬，千金裘。\n呼兒將出換美酒，與爾同銷萬古愁。',217,5,1,1,'2025-10-27 02:10:15','2025-10-27 04:42:05'),
(3,'騎單車～台北‧稻香水岸',1,'逛完北投焚化爐，可以順著大度路來「稻香水岸」走走。\n舊貴子坑溪位在關渡平原邊緣，在河岸旁原本就有道路可通行，近期新建一小段自行車道連接至大度路，可一路連接河岸道路至大業路527巷。\n這條道路前半段蜿蜒於關渡平原上，入口處大致位於慈濟靜思堂後方，其實整修的路段僅有一小段，往前行兩側景觀以稻田為主，要是收穫的季節，就是黃澄澄的稻穗搖曳；要是插秧時節，則是綠油油的田野景觀。',185,4,1,1,'2025-10-27 03:42:06','2025-10-27 04:41:56'),
(4,'舉頭三尺',10,'舉頭三尺有神明',7,4,1,1,'2025-10-27 04:44:45','2025-10-27 08:20:42'),
(5,'天公',10,'天公疼傻人',5,4,1,1,'2025-10-27 05:50:30','2025-10-27 08:20:36'),
(6,'心的悄悄話',11,'爺爺教我寫心字：「心是一葉舟，細雨灑輕舟，\n一點落舟前，一點落舟中，一點落舟後。」\n心的小船輕輕走，小船上要載什麼呢？\n只載秋天好不好？不好！不好！\n一下秋風吹，一下秋雨落，\n秋風秋雨落心上，讓人好發愁！',102,3,1,1,'2025-10-28 04:53:44','2025-10-28 11:02:24'),
(7,'你好，新朋友',11,'小草剛從泥土冒出，\n太陽伸出暖暖的手，拍拍小草說：\n「我是太陽，\n有一顆熱情的心。\n我讓\n水滴化成彩虹，\n大海也會閃閃發亮。」\n\n青山坐在湖邊畫畫，\n小雲雀輕快的飛過來說：\n「我是小雲雀，\n沒有多彩的羽衣，\n卻有清脆的歌聲。\n我喜歡一邊唱歌，\n一邊停留半空中。」\n\n風聽見樹葉慢慢落下，\n用長長的頭髮接住，呼呼的說：\n「我是風，\n最喜歡四處旅行，\n帶你去聞百合的花香，\n帶你去看成群的綿羊，\n再送你平安回地面的家。」\n\n教室裡有好多新同學，\n一個男孩向大家說：\n「我是開朗的小豆子，\n最會踢足球。\n人和球一起飛奔，\n是最快樂的時光。」',267,3,1,1,'2025-10-28 11:01:43','2025-10-28 11:02:14'),
(8,'我們的約定',11,'「老師，有人在走廊奔跑。」\n「老師，有人……。」\n開學不到幾天，各種「狀紙」已經堆滿老師的桌面。\n「看來，明天得找個時間，訂定班級公約。」\n同學們紛紛同意老師的看法。\n第二天的早自習，由班長小惠主持公約的訂定，我──小豆子當記錄。\n在老師的幫忙下，我們一一完成「教室走廊慢慢走」、「上課認真不聊天」等九個約定。\n因為大家發言很熱烈，讓我寫得很辛苦。\n當天下午，教室裡有了一張大大的班級公約。\n這些約定是用來提醒我們，但同學們的臉上卻「幾家歡樂幾家愁」。\n對我來說，「上課認真不聊天」這個約定有點難，因為我的好朋友阿福就坐在旁邊。\n不過，我們已經是三年級的學生了，我一定會努力做到，學會「自己管好自己」。',301,3,1,1,'2025-10-28 11:03:59','2025-10-28 11:03:59'),
(9,'下課十分鐘',11,'下課，短短的十分鐘，是大家最期待的時間。\n教室裡，有人靜靜的看書，也有人在一起聊天。\n教室外，有人去遊戲場溜滑梯、玩「鬼抓人」，\n也有人在操場上活動，有跑步的、打球的，\n還有玩「跳房子」的，每個角落都充滿歡樂的笑聲，真熱鬧！我呢？\n我喜歡和阿福去操場上踢足球。\n「小豆子，快傳！」\n「阿福，接著！」\n有時沒踢好，球就會從腳邊溜走；\n有時踢準了，球就會很聽話的朝球門飛去。\n「進球！」阿福手舞足蹈的歡呼著，表情非常神氣。\n「得分！得分！」\n這種在草地上飛奔的感覺，讓人暢快無比。\n只是，下課的快樂時光總是溜得特別快。\n當上課鐘聲一響，我們就得和足球說再見。\n回教室時，還不能得意忘形的在走廊跑了起來，\n因為班長小惠會很盡責的盯著我們。',316,3,1,1,'2025-10-28 11:05:35','2025-10-28 11:05:35'),
(10,'留住今天的太陽',11,'小時候，我常常指著天邊的太陽，\n問媽媽：「太陽為什麼會下山？太陽下山後，到哪裡去了？」\n媽媽笑著告訴我：「太陽躲到山裡睡覺，明天一早就會醒來。」\n望著火紅的夕陽，心裡有點失望，好想留住每一天的太陽。\n有一天放學，我看著夕陽，\n突發奇想：「我要和太陽比賽，要在太陽下山前回到家。」\n於是，加緊腳步，急速走著。我不理同學的玩鬧，也不管店家的叫賣聲，\n更不願逗留在玩具店的窗前，只想趕快回到家。\n一路上，追著自己的影子，很快就到家了。\n當我站在家門口，轉身看到夕陽對我露出笑臉，心裡充滿感動。\n我欣喜的告訴媽媽：「太陽還沒下山休息，我比太陽快！」\n從此以後，和太陽比賽成了我最喜歡的遊戲。\n以前，我的作業都是在太陽下山後才開始寫。\n現在，我一回家便專心寫作業，盡量在太陽還留在天邊前完成。\n這麼一來，由於有更多的時間，做自己想做的事，常讓我有勝利的喜悅。\n現在，我總在太陽下山前，乖乖的把該做的事情做完，來「留住」今天的太陽。\n當我看著太陽掛在天邊，露出溫暖的微笑，心裡就很得意。',437,3,1,1,'2025-10-28 11:07:39','2025-10-28 11:07:39'),
(11,'火大了',11,'小噴火龍丁丁最受不了的事，是找不到東西。\n「一定是哥哥做的好事，拿走我的玩具車！」\n丁丁肚子裡的怒火慢慢升高，朝哥哥大喊：「把玩具車還給我！」\n什麼也沒做的哥哥聽了很不開心，氣呼呼的說：「沒有就是沒有，誰要拿你的東西！」\n\n氣得跳腳的丁丁踢倒了桌椅，怒氣沖天的哥哥噴了幾口氣。\n他們身子變大，火力全開，你一言，我一語，兩張口朝對方噴出烈火。\n\n他們頭頂上的龍角變成「菱角」，白牙變成黑牙，臉也烏黑一片。\n兩兄弟一吐怒氣後，變大的身子才慢慢消下來。\n\n轉眼間，屋子裡的東西東倒西歪，消防警鈴大響。\n消防車快速趕來，水柱注入屋子，從沙發下沖出了好多玩具車。\n「你們知道管不住怒火的噴火龍，會變成什麼樣嗎？」消防員問。\n兩兄弟搖搖頭。\n\n「會氣到全身著火，不幸傷重而死。」消防員接著說。\n\n丁丁冷靜想一想，轉身向哥哥說：「我不該隨便生氣，對不起！」\n「不要緊，我原諒你。」哥哥回答。\n\n丁丁告訴自己，下次請人幫忙找一找，也許不用發脾氣。',415,3,1,1,'2025-10-28 11:09:56','2025-10-28 11:09:56'),
(12,'在天晴了的時候',11,'在天晴了的時候，\n該到小徑中去走走：\n給雨潤過的泥路，\n一定是涼爽又溫柔。\n炫耀著新綠的小草，\n已一下子洗淨了塵垢。\n不再膽怯的小白菊，\n慢慢的抬起它們的頭，\n試試寒，試試暖，\n然後一瓣瓣的綻透。\n抖去水珠的鳳蝶兒\n在木葉間自在閒遊，\n把牠的飾彩的智慧書頁\n曝著陽光一開一收。\n到小徑中去走走吧！\n在天晴了的時候：\n赤著腳，攜著手，\n踏著新泥，涉過溪流。\n新陽推開了陰霾了，\n溪水在溫風中暈皺，\n看山間移動的暗綠——\n雲的腳跡——它也在閒遊。',221,6,1,1,'2025-10-28 11:11:14','2025-10-28 11:11:14'),
(13,'珍珠鳥',11,'朋友送我一對珍珠鳥，我把牠們養在一個用竹條編成的籠子裡。\n籠內有一束乾草，那是小鳥舒適而溫暖的巢。\n\n有人說，這是一種怕人的鳥。\n\n我把籠子掛在窗前，那兒還有一盆異常茂盛的法國吊蘭，我用吊蘭長長的、生著小綠葉的串串藤蔓遮蓋在鳥籠上。小鳥就像躲進幽深的樹林裡一樣安全，從中傳出又細又亮的叫聲，也就格外輕盈自在了。陽光從窗外射入，透過吊蘭，那無數指甲狀的小葉，一半成了黑影，一半被照透，色彩交雜。小鳥的影子就在這中間隱約閃動，雖然看不清楚（有時連籠子也看不出），牠們可愛的鮮紅小嘴兒卻不時從綠葉中伸出來。\n\n我很少掀開葉蔓驚動牠們，牠們便漸漸敢伸出小腦袋看看我，我們就這樣一點一點熟悉了。\n\n不久，那一團愈發繁茂的藤蔓裡，發出一種尖細而嬌嫩的鳴叫。我猜，是牠們有了剛出生的幼鳥。我沒有掀開葉片往裡看，連添食加水時，也不睜大好奇的眼睛直視牠們。\n\n三個月後，忽然有一小腦袋從葉間探出來，正是這個小傢伙！牠小，就能輕易的由籠子縫隙鑽出身。看，多麼像牠的母親：紅嘴紅腳，灰藍色的毛，只是還沒有生出珍珠似的圓圓白點，整個身子好像一顆鬆軟的球兒。\n\n起先，這小傢伙只在籠子四周活動，隨後就在屋裡飛來飛去。牠一會兒落在櫃頂上，一會兒神氣十足的站在書架上，啄著書背上那些大文豪的名字，一會兒把燈繩撞得來回搖動，又趕忙逃到畫框上去。只要大鳥在籠子裡生氣的叫一聲，牠立即飛回籠裡去。我不去理會牠，這樣久了，即使打開窗子，牠最多只在窗框上站一會兒，絕不飛出去。\n\n漸漸的，牠膽子大了，就飛到我的書桌上。\n\n這小傢伙先是離我較遠，見我不去傷害牠，便一點一點挨近，然後蹦到我的杯子上，俯下頭來喝茶，再偏過臉看看我的反應。我只是微微一笑，照樣寫東西，牠就放開膽子跳到稿紙上，繞著我的筆尖蹦來蹦去，跳動的小紅爪子在紙上發出細微的ㄘㄚㄘㄚ聲響。\n\n我不動聲色的繼續寫，默默享受著這小傢伙親近的情意。這樣，牠完全放心了，索性用那小紅嘴，ㄉㄚㄉㄚ啄著我顫動的筆尖。我用手輕輕摸一摸牠柔細的短毛，牠也不怕，反而友好的啄兩下我的手指。白天，牠這樣淘氣的陪伴我，天色入暮，牠就在父母的再三呼喚聲中，飛向籠子，擺動滾圓的身子，擠開那些綠葉鑽進去。\n\n有一天，我正專注寫作時，牠居然落到我的肩上。我手中的筆不覺停了，生怕嚇跑牠。待一會兒，轉頭一看，這小傢伙竟趴在我的肩頭上睡著了，銀灰色的眼皮蓋住了眸子，小紅腳也剛好被胸上長長的絨毛蓋住。我輕輕抬一抬肩，牠沒醒，睡得好熟！還咂咂嘴，難道在做夢？\n\n我筆尖一動，流瀉下一時的感受：信賴，往往能創造出美好的境界。',1055,6,1,1,'2025-10-28 11:14:25','2025-10-28 11:14:25'),
(14,'客至',2,'舍南舍北皆春水，但見群鷗日日來。\n花徑不曾緣客掃，蓬門今始為君開。\n盤飧市遠無兼味，樽酒家貧只舊醅。\n肯與鄰翁相對飲，隔籬呼取盡餘杯。',67,6,1,1,'2025-10-28 11:15:24','2025-10-28 11:15:24');
/*!40000 ALTER TABLE `test_bank` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test_participants`
--

DROP TABLE IF EXISTS `test_participants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test_participants` (
  `test_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  PRIMARY KEY (`test_id`,`student_id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `test_participants_ibfk_1` FOREIGN KEY (`test_id`) REFERENCES `tests` (`id`) ON DELETE CASCADE,
  CONSTRAINT `test_participants_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test_participants`
--

LOCK TABLES `test_participants` WRITE;
/*!40000 ALTER TABLE `test_participants` DISABLE KEYS */;
/*!40000 ALTER TABLE `test_participants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test_questions`
--

DROP TABLE IF EXISTS `test_questions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test_questions` (
  `test_id` int(11) NOT NULL,
  `question_id` int(11) NOT NULL,
  PRIMARY KEY (`test_id`,`question_id`),
  KEY `question_id` (`question_id`),
  CONSTRAINT `test_questions_ibfk_1` FOREIGN KEY (`test_id`) REFERENCES `tests` (`id`) ON DELETE CASCADE,
  CONSTRAINT `test_questions_ibfk_2` FOREIGN KEY (`question_id`) REFERENCES `test_bank` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test_questions`
--

LOCK TABLES `test_questions` WRITE;
/*!40000 ALTER TABLE `test_questions` DISABLE KEYS */;
/*!40000 ALTER TABLE `test_questions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test_submissions`
--

DROP TABLE IF EXISTS `test_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test_submissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `time_taken_seconds` int(11) NOT NULL,
  `chars_completed` int(11) NOT NULL,
  `errors` int(11) NOT NULL,
  `wpm` decimal(5,1) NOT NULL,
  `submitted_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `test_id` (`test_id`),
  CONSTRAINT `test_submissions_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `users` (`id`),
  CONSTRAINT `test_submissions_ibfk_2` FOREIGN KEY (`test_id`) REFERENCES `tests` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test_submissions`
--

LOCK TABLES `test_submissions` WRITE;
/*!40000 ALTER TABLE `test_submissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `test_submissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tests`
--

DROP TABLE IF EXISTS `tests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `teacher_id` int(11) NOT NULL,
  `start_time` timestamp NOT NULL,
  `end_time` timestamp NOT NULL,
  `mode` enum('timed','measured') NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`settings`)),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `teacher_id` (`teacher_id`),
  CONSTRAINT `tests_ibfk_1` FOREIGN KEY (`teacher_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tests`
--

LOCK TABLES `tests` WRITE;
/*!40000 ALTER TABLE `tests` DISABLE KEYS */;
/*!40000 ALTER TABLE `tests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `typing_practice_logs`
--

DROP TABLE IF EXISTS `typing_practice_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `typing_practice_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `username` varchar(64) NOT NULL,
  `grade` tinyint(3) unsigned DEFAULT NULL,
  `practice_mode` enum('measured','timed') NOT NULL COMMENT 'measured=計字數, timed=限時',
  `target_chars` int(10) unsigned DEFAULT NULL COMMENT '指定字數（計時模式用）',
  `target_seconds` int(10) unsigned DEFAULT NULL COMMENT '練習秒數（限時模式用）',
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `duration_seconds` int(10) unsigned NOT NULL COMMENT '實際耗時（秒）',
  `question_text` mediumtext DEFAULT NULL COMMENT '題目完整內容（當次載入的題目）',
  `input_text` mediumtext DEFAULT NULL COMMENT '實際完成內容（逐行輸入合併）',
  `total_chars` int(10) unsigned NOT NULL DEFAULT 0 COMMENT '總字數',
  `correct_chars` int(10) unsigned NOT NULL DEFAULT 0 COMMENT '正確字數',
  `error_chars` int(10) unsigned NOT NULL DEFAULT 0 COMMENT '錯誤字數',
  `wpm` decimal(5,1) NOT NULL DEFAULT 0.0 COMMENT '每分鐘正確字數',
  `finish_reason` varchar(32) NOT NULL DEFAULT 'unknown' COMMENT 'manual-stop / auto-target / auto-timeout / auto-no-more-questions / other',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_time` (`user_id`,`start_time`),
  KEY `idx_mode` (`practice_mode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='練習的「成績」資料表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `typing_practice_logs`
--

LOCK TABLES `typing_practice_logs` WRITE;
/*!40000 ALTER TABLE `typing_practice_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `typing_practice_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL COMMENT '帳號',
  `name` varchar(100) NOT NULL COMMENT '儲存姓名',
  `class` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '班級ID陣列 (教師:[1,2], 學生:[1])' CHECK (json_valid(`class`)),
  `role` enum('admin','teacher','student') NOT NULL COMMENT '角色',
  `grade` int(11) DEFAULT NULL COMMENT '學生年級 (3-6)',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `update_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT '最後更新時間',
  `is_active` tinyint(1) DEFAULT 1 COMMENT '帳號是否啟用',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=355 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='使用者帳號表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES
(1,'typing','系統管理者',NULL,'admin',NULL,'2025-10-26 11:18:51','2025-10-26 11:18:51',1),
(2,'teacher','預設教師',NULL,'teacher',NULL,'2025-10-26 11:18:51','2025-11-10 14:57:00',1),
(3,'student','預設學生','[5]','student',3,'2025-10-26 11:18:51','2025-10-27 05:58:44',1),
(4,'weiwei','簡子翔',NULL,'admin',NULL,'2025-10-26 12:06:29','2025-10-27 07:24:27',1),
(8,'judy0715','林淑慧','[1,2,3,4,5,7,8,9,10,11,12,13,14,15,16,17]','teacher',NULL,'2025-11-03 05:29:58','2025-11-10 14:56:36',1),
(9,'rfs112103','蕭玉鉉','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(10,'rfs112104','江承軒','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(11,'rfs112056','戴子傑','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(12,'rfs112082','陳奕帆','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(13,'rfs112057','張安東','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(14,'rfs112033','簡儒林','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(15,'rfs112009','林弦錡','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(16,'rfs112036','郭冠坤','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(17,'rfs112061','郭晨宇','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(18,'rfs112013','陳昱玄','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(19,'rfs112041','吳絢昕','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(20,'rfs112113','陳妍綾','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(21,'ann1051120','徐巧恩','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(22,'rfs112018','許茵棋','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(23,'rfs112070','陳瀞羽','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(24,'rfs112094','盧歆穎','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(25,'rfs112095','林筠芯','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(26,'rfs112021','吳苡榛','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(27,'rfs112023','周詩婕','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(28,'rfs112049','謝品歆','[1]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(29,'rfs112099','王城恩','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(30,'rfs112027','鄧海鴋','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(31,'rfs112002','林昱佑','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(32,'rfs112101','高存聲','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(33,'rfs112055','陳亞恩','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(34,'rfs112031','李鈺翔','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(35,'rfs112032','黃琮峻','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(36,'rfs112059','潘柏閎','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(37,'rfs112085','魏宇成','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(38,'rfs112086','何宇凡','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(39,'rfs112109','廖唯宇','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(40,'rfs112133','廖妍歆','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(41,'rfs112115','李語婕','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(42,'rfs112069','吳苡喬','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(43,'rfs112118','洪宇晴','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(44,'rfs112046','莊凱斐','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(45,'rfs112047','鄭羽晴','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(46,'rfs112135','陳星妤','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(47,'rfs112022','林樂媗','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(48,'rfs112024','劉又茹','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(49,'rfs112097','呂婕馜','[2]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(50,'rfs112051','陳宇雍','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(51,'rfs112100','楊一飛','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(52,'rfs112076','余紹珉','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(53,'rfs112005','王又立','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(54,'rfs112080','鄭佑廷','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(55,'rfs112105','張嘉瑞','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(56,'rfs112107','張竣彥','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(57,'rfs112034','蔡尉超','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(58,'rfs112010','張旭海','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(59,'rfs112132','林典昇','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(60,'rfs112060','黃閔浩','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(61,'rfs112110','蔡景安','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(62,'rfs112040','黃雪貞','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(63,'rfs112015','廖恩彤','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(64,'rfs112066','洪羽芯','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(65,'rfs112068','王妤庭','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(66,'rfs112116','謝姀霏','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(67,'rfs112045','賴子歆','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(68,'rfs112092','林昕穎','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(69,'rfs112093','劉羽蕎','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(70,'rfs112123','楊梓彤','[3]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(71,'rfs112074','王均碩','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(72,'rfs112028','郭峻齊','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(73,'rfs112001','陳昱愷','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(74,'rfs112077','黃勝濬','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(75,'rfs112053','連宥竑','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(76,'rfs112004','洪旻志','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(77,'rfs112079','陳泓宇','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(78,'rfs112106','陳禾峰','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(79,'rfs112130','黃敏鎬','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(80,'rfs112108','楊侑軒','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(81,'rfs112063','張宇','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(82,'rfs112088','陳又綺','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(83,'rfs112064','黃琳恩','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(84,'rfs112042','高苡芯','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(85,'rfs112016','蘇祤芯','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(86,'rfs112017','林宥蓁','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(87,'rfs112091','徐若緹','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(88,'rfs112117','童禹晞','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(89,'rfs112119','廖婉亘','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(90,'rfs112073','涂永晴','[4]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(91,'ytj1007','姚廷駿','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(92,'rfs112075','高楷宸','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(93,'rfs112003','簡煒珉','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(94,'rfs112128','張秉勳','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(95,'rfs112030','劉韋成','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(96,'rfs112102','賴子安','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(97,'rfs112006','蘇旻熙','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(98,'rfs112058','周子閎','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(99,'howard1060511','金皓崴','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(100,'rfs112037','蘇隆順','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(101,'rfs112039','詹羽皓','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(102,'rfs112111','吳宜真','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(103,'rfs112065','黃琳惠','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(104,'rfs112043','黃珮綺','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(105,'rfs112090','史采容','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(106,'rfs112044','王依彙','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(107,'rfs112121','陳宥溱','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(108,'rfs112020','何泱瑾','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(109,'rfs112072','李崢誼','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(110,'rfs112071','李康誼','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(111,'rfs112096','涂永縈','[5]','student',3,'2025-11-10 14:55:54','2025-11-10 14:55:54',1),
(112,'rfs111028','廖佑勛','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(113,'rfs111059','黃宥凱','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(114,'rfs111115','許凱傑','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(115,'rfs111008','謝子祥','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(116,'rfs111089','陳宣翰','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(117,'rfs111010','高晨愷','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(118,'rfs111034','沈汯諺','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(119,'rfs111091','曾羽岑','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(120,'rfs111065','王宇勛','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(121,'rfs111013','黃彥凱','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(122,'rfs111067','陳俊豪','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(123,'rfs111019','陳睿敏','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(124,'rfs111051','賴依宸','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(125,'rfs111131','李芃樂','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(126,'rfs111133','江玉蘭','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(127,'rfs111081','潘榆潔','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(128,'zsc0218','張韶純','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(129,'rfs111108','林宥臻','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(130,'lyb1109','羅宇彬','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(131,'lyt4596','賴宥廷','[7]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(132,'rfs111082','廖晟懿','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(133,'rfs111002','陳朋駟','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(134,'rfs111003','蘇昱恩','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(135,'rfs111137','吳英豪','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(136,'rfs111086','胡詠謙','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(137,'rfs111061','張允赫','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(138,'rfs111087','吳柏諺','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(139,'rfs111063','胡碩元','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(140,'rfs111033','胡煜安','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(141,'rfs111120','黃宥竣','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(142,'rfs111035','賴辰宇','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(143,'rfs111040','張凱恩','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(144,'rfs111042','江苡萌','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(145,'rfs111016','石伊瑤','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(146,'rfs111043','史芊寓','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(147,'rfs111017','潘芷萱','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(148,'rfs111097','蔡喬媗','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(149,'rfs111073','林芳甄','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(150,'rfs11127','葉姿岑','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(151,'rfs111021','謝羽芯','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(152,'rfs111075','陳子欣','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(153,'rfs111106','䌓風瑩','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(154,'rfs111132','王星霏','[8]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(155,'rfs111110','黃御翔','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(156,'rfs111055','林志凱','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(157,'rfs111058','林駿廷','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(158,'rfs111029','詹秉杰','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(159,'rfs111084','謝凱桐','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(160,'rfs111060','潘建宇','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(161,'rfs111006','林弦諹','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(162,'rfs111085','范立強','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(163,'rfs111032','張傑元','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(164,'rfs111116','嚴愷衡','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(165,'rfs111118','江道樺','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(166,'rfs111012','黃律淳','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(167,'rfs111123','康晉恩','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(168,'rfs111070','李歆蕾','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(169,'rfs111072','廖畇菲','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(170,'rfs111020','楊涵茵','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(171,'rfs111049','廖姵晨','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(172,'rfs111128','陳姷妤','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(173,'rfs111103','李奕菲','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(174,'rfs111129','賴雨彤','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(175,'rfs111022','廖曼茵','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(176,'rfs111142','彭柏妮','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(177,'rfs111130','鄭妤婕','[9]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(178,'rfs111109','李宥逸','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(179,'rfs111113','王御安','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(180,'hcy1124','洪杰宥','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(181,'rfs111030','程彥霖','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(182,'rfs111009','林詳硯','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(183,'rfs111117','周旭騰','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(184,'rfs111121','黃佑威','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(185,'rfs111090','賴奕安','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(186,'rfs111092','張俊宏','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(187,'rfs111066','蕭宇辰','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(188,'rfs111093','方奕軒','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(189,'rfs111069','賴奕綺','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(190,'rfs111126','劉又寧','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(191,'rfs111074','余苡綸','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(192,'rfs111101','陳映筑','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(193,'rfs111104','吳嘉琪','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(194,'rfs111052','邱雨晴','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(195,'rfs111078','蘇芮安','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(196,'rfs111100','游佳璇','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(197,'rfs111023','楊可彤','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(198,'rfs111054','鄭亘茵','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(199,'rfs111025','陳熹樂','[10]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(200,'rfs111057','林柏樺','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(201,'rfs111004','黃瑞楷','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(202,'rfs111007','李權祐','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(203,'rfs111062','林會翔','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(204,'rfs111138','陳育愷','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(205,'rfs111088','胡鈞惟','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(206,'rfs111119','陳祐勛','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(207,'rfs111037','林冠余','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(208,'alan1050531','蔡宥廷','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(209,'rfs111094','劉泫瑀','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(210,'rfs111014','吳承晏','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(211,'rfs111038','何品言','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(212,'rfs111125','劉于蓁','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(213,'rfs111018','林芸榛','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(214,'rfs111098','陳芯語','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(215,'rfs111099','余苡瑄','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(216,'rfs111146','黃芝妤','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(217,'rfs111046','林熙真','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(218,'rfs111026','楊皓淇','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(219,'phx0202','彭禾薰','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(220,'rfs111076','孫育琋','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(221,'rfs111077','黃可潔','[11]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(222,'rfs111001','倪浩文','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(223,'rfs111111','張棋竤','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(224,'rfs111056','詹逸豪','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(225,'rfs111114','邱奕翔','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(226,'rfs111005','林家禾','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(227,'rfs111031','吳宥燊','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(228,'rfs111011','李翼','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(229,'rfs111036','廖元墉','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(230,'rfs111095','李杰陽','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(231,'rfs111068','陳翊鍀','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(232,'rfs111039','周承鋐','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(233,'rfs111096','徐語恒','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(234,'rfs111141','吳振宇','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(235,'rfs111041','謝承軒','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(236,'rfs111124','謝依姍','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(237,'rfs111145','潘妍熙','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(238,'rfs111071','李依庭','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(239,'rfs111015','宋若瑜','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(240,'rfs111045','吳婕希','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(241,'rfs111047','陳姿嫚','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(242,'rfs111102','楊芷萱','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(243,'rfs111080','陳俐帆','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(244,'rfs111024','潘芝霖','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(245,'rfs111134','曹晏淳','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(246,'rfs111107','江奕霏','[12]','student',4,'2025-11-10 14:57:19','2025-11-10 14:57:19',1),
(247,'rfs110066','謝松諺','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(248,'rfs110002','陳宇熙','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(249,'rfs110027','謝炘叡','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(250,'rfs110090','吳彥呈','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(251,'rfs110030','柯柏瑄','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(252,'che0207','陳昊恩','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(253,'rfs110006','羅世哲','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(254,'rfs110008','余俊頡','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(255,'lyc150606','林宥逡','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(256,'rfs110032','莊凱閔','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(257,'rfs110113','蘇妤恩','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(258,'rfs110013','蕭苡軒','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(259,'rfs110036','方紫彤','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(260,'rfs110079','林莉婷','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(261,'rfs110101','廖芫艾','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(262,'rfs110080','劉羽晴','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(263,'rfs110016','林詠馨','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(264,'rfs110105','曾莞喬','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(265,'rfs110064','王品涵','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(266,'rfs110106','李安晴','[13]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(267,'rfs11002','劉勁硯','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(268,'rfs110067','鐘宇威','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(269,'rfs110045','劉麒霖','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(270,'rfs110088','詹侑叡','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(271,'rfs110091','余秉學','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(272,'rfs110004','黃彥承','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(273,'rfs110093','賴彥丞','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(274,'rfs110031','林帛諺','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(275,'rfs110094','周昱帆','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(276,'rfs110096','周子軒','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(277,'rfs110052','詹育齊','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(278,'rfs110012','方雅歆','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(279,'rfs110114','蘇妤宸','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(280,'rfs110033','陳羽葳','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(281,'rfs110034','趙薰慈','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(282,'rfs110056','魏宇彤','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(283,'sjx0131','胡珈萱','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(284,'rfs110057','余采歆','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(285,'rfs110103','江佳慧','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(286,'rfs110058','陳采薰','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(287,'rfs110122','陳雯靜','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(288,'rfs110063','蘇宥尹','[14]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(289,'rfs110022','許韋翔','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(290,'rfs110044','林郅宸','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(291,'rfs110024','莊翔聿','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(292,'rfs110029','蕭雋洋','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(293,'rfs110005','楊廷風','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(294,'rfs110092','洪靖棨','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(295,'rfs110072','廖宇博','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(296,'rfs110095','林紹安','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(297,'rfs110051','劉子鋐','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(298,'rfs110009','潘裕信','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(299,'rfs110054','黃鼎鈞','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(300,'s110110','周晨曦','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(301,'rfs110055','王星甯','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(302,'rfs110014','李祈萱','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(303,'rfs110037','陳蕎瑄','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(304,'rfs110081','陳柔芸','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(305,'rfs110017','林梓晴','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(306,'rfs110082','林子甯','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(307,'rfs110042','呂芓晴','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(308,'rfs110020','黃亮橙','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(309,'rfs110085','潘姿綺','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(310,'rfs110107','趙融安','[15]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(311,'rfs110026','黃泓潣','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(312,'rfs110046','盧以恩','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(313,'rfs110048','藍禾諺','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(314,'rfs110071','郭建辰','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(315,'rfs110049','張為森','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(316,'rfs110073','高煜恩','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(317,'rfs110010','許皓崴','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(318,'rfs110097','白烽廷','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(319,'rfs110076','張承睿','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(320,'ccf150831','詹駿烽','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(321,'rfs110099','蔡宛芳','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(322,'rfs110078','洪米妮','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(323,'rfs110111','吳芸萱','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(324,'rfs110102','陳姵瑄','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(325,'rfs110018','楊雯淇','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(326,'rfs110104','林聿旃','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(327,'rfs110061','柯懿軒','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(328,'rfs110062','莊佩璇','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(329,'rfs110083','黃宥璇','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(330,'rfs110043','俞恩淋','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(331,'rfs110084','連鳳姝','[16]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(332,'rfs110023','李柏毅','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(333,'rfs110087','林家樂','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(334,'rfs110068','周昊頤','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(335,'rfs110003','林昱樺','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(336,'rfs110047','鄭宇祥','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(337,'rfs110028','潘嘉軒','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(338,'rfs110070','蕭元希','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(339,'rfs110074','涂睿文','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(340,'rfs110075','林子棋','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(341,'rfs110053','王辰恩','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(342,'rfs110011','陳胤誠','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(343,'rfs110098','陳依昕','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(344,'rfs110035','鄭采媛','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(345,'rfs110038','沈歆霓','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(346,'rfs110015','劉士瑜','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(347,'rfs110059','何昱萱','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(348,'hzh0413','黃芷姮','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(349,'rfs110060','吳詩棋','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(350,'rfs110040','古梓廷','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(351,'rfs110115','吳芷安','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(352,'rfs110086','蔡靜瑄','[17]','student',5,'2025-11-10 14:57:24','2025-11-10 14:57:24',1),
(353,'tony','郭書軒',NULL,'teacher',NULL,'2025-11-17 04:44:06','2025-11-17 04:44:06',1),
(354,'san','王聖淳','[6]','teacher',NULL,'2025-11-17 04:51:54','2025-11-17 04:52:31',1);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-11-20 22:27:58
